/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.Appender;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.BuiltQuery;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.Function;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.FunctionFactory;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.Ordering;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.QueryStringBuilder;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.Select;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.TimeZone;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.Where;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.WithSubquery;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.clauses.Clause;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.clauses.FromClause;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.clauses.RawTextClause;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.clauses.SubQueryFromClause;

public class SelectCoreImpl<T extends Where>
implements Select,
QueryStringBuilder,
WithSubquery {
    private FromClause table;
    private final boolean isDistinct;
    private final List<Object> columns;
    protected final T where;
    private final Optional<String> intoMeasurement;
    private Optional<Ordering> ordering = Optional.empty();
    private List<Object> groupByColumns;
    private Optional<Function> fill = Optional.empty();
    private Optional<Integer> limit = Optional.empty();
    private Optional<Long> offSet = Optional.empty();
    private Optional<Integer> sLimit = Optional.empty();
    private Optional<Long> sOffSet = Optional.empty();
    private Optional<TimeZone> timeZone = Optional.empty();

    SelectCoreImpl(List<Object> columns, boolean isDistinct, T where) {
        this.columns = columns;
        this.isDistinct = isDistinct;
        this.where = where;
        this.intoMeasurement = Optional.empty();
    }

    SelectCoreImpl(List<Object> columns, boolean isDistinct, T where, String intoMeasurement) {
        this.columns = columns;
        this.isDistinct = isDistinct;
        this.where = where;
        this.intoMeasurement = intoMeasurement != null ? Optional.of(intoMeasurement) : Optional.empty();
    }

    SelectCoreImpl(FromClause table, List<Object> columns, boolean isDistinct, T where) {
        this.table = table;
        this.columns = columns;
        this.isDistinct = isDistinct;
        this.where = where;
        this.intoMeasurement = Optional.empty();
    }

    SelectCoreImpl(FromClause table, List<Object> columns, boolean isDistinct, T where, String intoMeasurement) {
        this.table = table;
        this.columns = columns;
        this.isDistinct = isDistinct;
        this.where = where;
        this.intoMeasurement = intoMeasurement != null ? Optional.of(intoMeasurement) : Optional.empty();
    }

    @Override
    public T where() {
        return this.where;
    }

    @Override
    public T where(Clause clause) {
        return this.where.and(clause);
    }

    @Override
    public T where(String text) {
        return this.where.and(new RawTextClause(text));
    }

    public Select orderBy(Ordering ordering) {
        this.ordering = Optional.of(ordering);
        return this;
    }

    public Select groupBy(Object ... columns) {
        this.groupByColumns = Arrays.asList(columns);
        return this;
    }

    public Select fill(Number value) {
        this.fill = Optional.of(FunctionFactory.function("fill", value));
        return this;
    }

    public Select fill(String value) {
        if ("linear".equals(value) || "none".equals(value) || "null".equals(value) || "previous".equals(value)) {
            this.fill = Optional.of(FunctionFactory.function("fill", value));
            return this;
        }
        throw new IllegalArgumentException("Please give a numeric value or linear, none, null, previous");
    }

    public Select limit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("Invalid LIMIT value, must be strictly positive");
        }
        if (this.limit.isPresent()) {
            throw new IllegalStateException("A LIMIT value has already been provided");
        }
        this.limit = Optional.of(limit);
        return this;
    }

    public Select limit(int limit, long offSet) {
        if (limit <= 0 || offSet <= 0L) {
            throw new IllegalArgumentException("Invalid LIMIT and OFFSET Value, must be strictly positive");
        }
        this.limit = Optional.of(limit);
        this.offSet = Optional.of(offSet);
        return this;
    }

    public Select sLimit(int sLimit) {
        if (sLimit <= 0) {
            throw new IllegalArgumentException("Invalid SLIMIT value, must be strictly positive");
        }
        if (this.sLimit.isPresent()) {
            throw new IllegalStateException("A SLIMIT value has already been provided");
        }
        this.sLimit = Optional.of(sLimit);
        return this;
    }

    public Select sLimit(int sLimit, long sOffSet) {
        if (sLimit <= 0 || sOffSet <= 0L) {
            throw new IllegalArgumentException("Invalid LIMIT and OFFSET Value, must be strictly positive");
        }
        this.sLimit = Optional.of(sLimit);
        this.sOffSet = Optional.of(sOffSet);
        return this;
    }

    public Select tz(String timezone) {
        this.timeZone = Optional.of(new TimeZone(timezone));
        return this;
    }

    @Override
    public void setSubQuery(QueryStringBuilder query) {
        this.table = new SubQueryFromClause(query);
    }

    @Override
    public StringBuilder buildQueryString() {
        return this.buildQueryString(new StringBuilder());
    }

    @Override
    public StringBuilder buildQueryString(StringBuilder builder) {
        builder.append("SELECT ");
        if (this.isDistinct && this.columns.size() > 1) {
            throw new IllegalStateException("DISTINCT function can only be used with one column");
        }
        if (this.columns == null || this.columns.size() == 0) {
            builder.append('*');
        } else {
            Appender.joinAndAppendNames(builder, this.columns);
        }
        if (this.intoMeasurement.isPresent()) {
            builder.append(" INTO ").append(this.intoMeasurement.get());
        }
        builder.append(" FROM ");
        if (this.table == null) {
            throw new IllegalStateException();
        }
        this.table.appendTo(builder);
        if (!this.where.getClauses().isEmpty()) {
            builder.append(" WHERE ");
            Appender.joinAndAppend(builder, this.where.getClauses());
        }
        if (this.groupByColumns != null) {
            builder.append(" GROUP BY ");
            Appender.joinAndAppendNames(builder, this.groupByColumns);
        }
        if (this.fill.isPresent()) {
            builder.append(" ");
            Appender.appendValue(this.fill.get(), builder);
        }
        if (this.ordering.isPresent()) {
            builder.append(" ORDER BY ");
            Appender.joinAndAppend(builder, ",", Collections.singletonList(this.ordering.get()));
        }
        if (this.limit.isPresent()) {
            builder.append(" LIMIT ").append(this.limit.get());
        }
        if (this.offSet.isPresent()) {
            builder.append(" OFFSET ").append(this.offSet.get());
        }
        if (this.sLimit.isPresent()) {
            builder.append(" SLIMIT ").append(this.sLimit.get());
        }
        if (this.sOffSet.isPresent()) {
            builder.append(" SOFFSET ").append(this.sOffSet.get());
        }
        if (this.timeZone.isPresent()) {
            this.timeZone.get().appendTo(builder);
        }
        BuiltQuery.trimLast(builder);
        return builder;
    }
}

