/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.influxdb.shaded.org.influxdb.msgpack;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.InfluxDBException;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.dto.QueryResult;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.msgpack.QueryResultModelPath;
import org.msgpack.core.ExtensionTypeHeader;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.ValueType;

public class MessagePackTraverser {
    private static final byte MSG_PACK_TIME_EXT_TYPE = 5;
    private String lastStringNode;

    public Iterable<QueryResult> traverse(InputStream is) {
        final MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((InputStream)is);
        return () -> new Iterator<QueryResult>(){

            @Override
            public boolean hasNext() {
                try {
                    return unpacker.hasNext();
                }
                catch (IOException e) {
                    throw new InfluxDBException(e);
                }
            }

            @Override
            public QueryResult next() {
                return MessagePackTraverser.this.parse(unpacker);
            }
        };
    }

    public QueryResult parse(InputStream is) {
        MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((InputStream)is);
        return this.parse(unpacker);
    }

    private QueryResult parse(MessageUnpacker unpacker) {
        QueryResult queryResult = new QueryResult();
        QueryResultModelPath queryResultPath = new QueryResultModelPath();
        queryResultPath.add("queryResult", queryResult);
        try {
            this.traverse(unpacker, queryResultPath, 1);
        }
        catch (IOException e) {
            throw new InfluxDBException(e);
        }
        return queryResult;
    }

    void traverse(MessageUnpacker unpacker, QueryResultModelPath queryResultPath, int readAmount) throws IOException {
        for (int amount = 0; unpacker.hasNext() && amount < readAmount; ++amount) {
            MessageFormat format = unpacker.getNextFormat();
            ValueType type = format.getValueType();
            Object o = null;
            String addedName = null;
            Object addedObject = null;
            block0 : switch (type) {
                case NIL: {
                    unpacker.unpackNil();
                    break;
                }
                case BOOLEAN: {
                    o = unpacker.unpackBoolean();
                    break;
                }
                case INTEGER: {
                    switch (format) {
                        case UINT64: {
                            o = unpacker.unpackBigInteger();
                            break block0;
                        }
                        case INT64: 
                        case UINT32: {
                            o = unpacker.unpackLong();
                            break block0;
                        }
                    }
                    o = unpacker.unpackInt();
                    break;
                }
                case FLOAT: {
                    o = unpacker.unpackDouble();
                    break;
                }
                case STRING: {
                    Map<String, String> tags;
                    o = unpacker.unpackString();
                    this.lastStringNode = (String)o;
                    if ("name".equals(o) && queryResultPath.compareEndingPath("series")) {
                        queryResultPath.add("name", null);
                        break;
                    }
                    if (queryResultPath.compareEndingPath("name")) {
                        queryResultPath.removeLast();
                        QueryResult.Series series = (QueryResult.Series)queryResultPath.getLastObject();
                        series.setName((String)o);
                        break;
                    }
                    if (queryResultPath.compareEndingPath("tags")) {
                        queryResultPath.add("tagKey", o);
                        break;
                    }
                    if (queryResultPath.compareEndingPath("tagKey")) {
                        String tagKey = (String)queryResultPath.getLastObject();
                        queryResultPath.removeLast();
                        tags = (Map)queryResultPath.getLastObject();
                        tags.put(tagKey, (String)o);
                        break;
                    }
                    if (!queryResultPath.compareEndingPath("columns")) break;
                    List columns = (List)queryResultPath.getLastObject();
                    columns.add((String)o);
                    break;
                }
                case BINARY: {
                    int length = unpacker.unpackBinaryHeader();
                    byte[] dst = new byte[length];
                    unpacker.readPayload(dst);
                    break;
                }
                case ARRAY: {
                    int length = unpacker.unpackArrayHeader();
                    if (length <= 0) break;
                    if ("results".equals(this.lastStringNode)) {
                        QueryResult queryResult = (QueryResult)queryResultPath.getLastObject();
                        ArrayList<QueryResult.Result> results = new ArrayList<QueryResult.Result>();
                        queryResult.setResults(results);
                        addedName = "results";
                        addedObject = results;
                    } else if ("series".equals(this.lastStringNode) && queryResultPath.compareEndingPath("result")) {
                        QueryResult.Result result = (QueryResult.Result)queryResultPath.getLastObject();
                        ArrayList<QueryResult.Series> series = new ArrayList<QueryResult.Series>();
                        result.setSeries(series);
                        addedName = "seriesList";
                        addedObject = series;
                    } else if ("columns".equals(this.lastStringNode) && queryResultPath.compareEndingPath("series")) {
                        QueryResult.Series series = (QueryResult.Series)queryResultPath.getLastObject();
                        ArrayList<String> columns = new ArrayList<String>();
                        series.setColumns(columns);
                        addedName = "columns";
                        addedObject = columns;
                    } else if ("values".equals(this.lastStringNode) && queryResultPath.compareEndingPath("series")) {
                        QueryResult.Series series = (QueryResult.Series)queryResultPath.getLastObject();
                        ArrayList<List<Object>> values = new ArrayList<List<Object>>();
                        series.setValues(values);
                        addedName = "values";
                        addedObject = values;
                    } else if (queryResultPath.compareEndingPath("values")) {
                        List values = (List)queryResultPath.getLastObject();
                        ArrayList value = new ArrayList();
                        values.add(value);
                        addedName = "value";
                        addedObject = value;
                    }
                    if (addedName != null) {
                        queryResultPath.add(addedName, addedObject);
                    }
                    this.traverse(unpacker, queryResultPath, length);
                    if (addedName == null) break;
                    queryResultPath.removeLast();
                    break;
                }
                case MAP: {
                    Map<String, String> tags;
                    int length = unpacker.unpackMapHeader();
                    if (queryResultPath.compareEndingPath("results")) {
                        List results = (List)queryResultPath.getLastObject();
                        QueryResult.Result result = new QueryResult.Result();
                        results.add(result);
                        addedName = "result";
                        addedObject = result;
                    } else if (queryResultPath.compareEndingPath("seriesList")) {
                        List series = (List)queryResultPath.getLastObject();
                        QueryResult.Series s = new QueryResult.Series();
                        series.add(s);
                        addedName = "series";
                        addedObject = s;
                    } else if ("tags".equals(this.lastStringNode) && queryResultPath.compareEndingPath("series")) {
                        QueryResult.Series series = (QueryResult.Series)queryResultPath.getLastObject();
                        tags = new HashMap<String, String>();
                        series.setTags(tags);
                        addedName = "tags";
                        addedObject = tags;
                    }
                    if (addedName != null) {
                        queryResultPath.add(addedName, addedObject);
                    }
                    for (int i = 0; i < length; ++i) {
                        this.traverse(unpacker, queryResultPath, 1);
                        this.traverse(unpacker, queryResultPath, 1);
                    }
                    if (addedName == null) break;
                    queryResultPath.removeLast();
                    break;
                }
                case EXTENSION: {
                    int nanosStartIndex = 8;
                    ExtensionTypeHeader extension = unpacker.unpackExtensionTypeHeader();
                    if (extension.getType() != 5) break;
                    byte[] dst = new byte[extension.getLength()];
                    unpacker.readPayload(dst);
                    ByteBuffer bf = ByteBuffer.wrap(dst, 0, extension.getLength());
                    long epochSeconds = bf.getLong();
                    int nanosOffset = bf.getInt(8);
                    o = TimeUnit.SECONDS.toNanos(epochSeconds) + (long)nanosOffset;
                    break;
                }
            }
            if (!queryResultPath.compareEndingPath("value")) continue;
            List value = (List)queryResultPath.getLastObject();
            value.add(o);
        }
    }
}

