/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.influxdb.shaded.com.squareup.moshi;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.apache.flink.metrics.influxdb.shaded.com.squareup.moshi.AdapterMethodsFactory;
import org.apache.flink.metrics.influxdb.shaded.com.squareup.moshi.ArrayJsonAdapter;
import org.apache.flink.metrics.influxdb.shaded.com.squareup.moshi.ClassJsonAdapter;
import org.apache.flink.metrics.influxdb.shaded.com.squareup.moshi.CollectionJsonAdapter;
import org.apache.flink.metrics.influxdb.shaded.com.squareup.moshi.JsonAdapter;
import org.apache.flink.metrics.influxdb.shaded.com.squareup.moshi.JsonQualifier;
import org.apache.flink.metrics.influxdb.shaded.com.squareup.moshi.JsonReader;
import org.apache.flink.metrics.influxdb.shaded.com.squareup.moshi.JsonWriter;
import org.apache.flink.metrics.influxdb.shaded.com.squareup.moshi.MapJsonAdapter;
import org.apache.flink.metrics.influxdb.shaded.com.squareup.moshi.StandardJsonAdapters;
import org.apache.flink.metrics.influxdb.shaded.com.squareup.moshi.Types;
import org.apache.flink.metrics.influxdb.shaded.com.squareup.moshi.internal.Util;

public final class Moshi {
    static final List<JsonAdapter.Factory> BUILT_IN_FACTORIES = new ArrayList<JsonAdapter.Factory>(5);
    private final List<JsonAdapter.Factory> factories;
    private final ThreadLocal<LookupChain> lookupChainThreadLocal = new ThreadLocal();
    private final Map<Object, JsonAdapter<?>> adapterCache = new LinkedHashMap();

    Moshi(Builder builder) {
        ArrayList<JsonAdapter.Factory> factories = new ArrayList<JsonAdapter.Factory>(builder.factories.size() + BUILT_IN_FACTORIES.size());
        factories.addAll(builder.factories);
        factories.addAll(BUILT_IN_FACTORIES);
        this.factories = Collections.unmodifiableList(factories);
    }

    @CheckReturnValue
    public <T> JsonAdapter<T> adapter(Type type) {
        return this.adapter(type, Util.NO_ANNOTATIONS);
    }

    @CheckReturnValue
    public <T> JsonAdapter<T> adapter(Class<T> type) {
        return this.adapter(type, Util.NO_ANNOTATIONS);
    }

    @CheckReturnValue
    public <T> JsonAdapter<T> adapter(Type type, Class<? extends Annotation> annotationType) {
        if (annotationType == null) {
            throw new NullPointerException("annotationType == null");
        }
        return this.adapter(type, Collections.singleton(Types.createJsonQualifierImplementation(annotationType)));
    }

    @CheckReturnValue
    public <T> JsonAdapter<T> adapter(Type type, Class<? extends Annotation> ... annotationTypes) {
        if (annotationTypes.length == 1) {
            return this.adapter(type, annotationTypes[0]);
        }
        LinkedHashSet<Annotation> annotations = new LinkedHashSet<Annotation>(annotationTypes.length);
        for (Class<? extends Annotation> annotationType : annotationTypes) {
            annotations.add(Types.createJsonQualifierImplementation(annotationType));
        }
        return this.adapter(type, Collections.unmodifiableSet(annotations));
    }

    @CheckReturnValue
    public <T> JsonAdapter<T> adapter(Type type, Set<? extends Annotation> annotations) {
        return this.adapter(type, annotations, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckReturnValue
    public <T> JsonAdapter<T> adapter(Type type, Set<? extends Annotation> annotations, @Nullable String fieldName) {
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        if (annotations == null) {
            throw new NullPointerException("annotations == null");
        }
        type = Util.canonicalize(type);
        Object cacheKey = this.cacheKey(type, annotations);
        Map<Object, JsonAdapter<?>> map = this.adapterCache;
        synchronized (map) {
            JsonAdapter<?> result = this.adapterCache.get(cacheKey);
            if (result != null) {
                return result;
            }
        }
        LookupChain lookupChain = this.lookupChainThreadLocal.get();
        if (lookupChain == null) {
            lookupChain = new LookupChain();
            this.lookupChainThreadLocal.set(lookupChain);
        }
        boolean success = false;
        JsonAdapter adapterFromCall = lookupChain.push(type, fieldName, cacheKey);
        try {
            if (adapterFromCall != null) {
                JsonAdapter jsonAdapter = adapterFromCall;
                return jsonAdapter;
            }
            int i = 0;
            int size = this.factories.size();
            while (i < size) {
                JsonAdapter<?> result = this.factories.get(i).create(type, annotations, this);
                if (result != null) {
                    lookupChain.adapterFound(result);
                    success = true;
                    JsonAdapter<?> jsonAdapter = result;
                    return jsonAdapter;
                }
                ++i;
            }
            throw new IllegalArgumentException("No JsonAdapter for " + Util.typeAnnotatedWithAnnotations(type, annotations));
        }
        catch (IllegalArgumentException e) {
            throw lookupChain.exceptionWithLookupStack(e);
        }
        finally {
            lookupChain.pop(success);
        }
    }

    @CheckReturnValue
    public <T> JsonAdapter<T> nextAdapter(JsonAdapter.Factory skipPast, Type type, Set<? extends Annotation> annotations) {
        if (annotations == null) {
            throw new NullPointerException("annotations == null");
        }
        type = Util.canonicalize(type);
        int skipPastIndex = this.factories.indexOf(skipPast);
        if (skipPastIndex == -1) {
            throw new IllegalArgumentException("Unable to skip past unknown factory " + skipPast);
        }
        int size = this.factories.size();
        for (int i = skipPastIndex + 1; i < size; ++i) {
            JsonAdapter<?> result = this.factories.get(i).create(type, annotations, this);
            if (result == null) continue;
            return result;
        }
        throw new IllegalArgumentException("No next JsonAdapter for " + Util.typeAnnotatedWithAnnotations(type, annotations));
    }

    @CheckReturnValue
    public Builder newBuilder() {
        int fullSize = this.factories.size();
        int tailSize = BUILT_IN_FACTORIES.size();
        List<JsonAdapter.Factory> customFactories = this.factories.subList(0, fullSize - tailSize);
        return new Builder().addAll(customFactories);
    }

    private Object cacheKey(Type type, Set<? extends Annotation> annotations) {
        if (annotations.isEmpty()) {
            return type;
        }
        return Arrays.asList(type, annotations);
    }

    static {
        BUILT_IN_FACTORIES.add(StandardJsonAdapters.FACTORY);
        BUILT_IN_FACTORIES.add(CollectionJsonAdapter.FACTORY);
        BUILT_IN_FACTORIES.add(MapJsonAdapter.FACTORY);
        BUILT_IN_FACTORIES.add(ArrayJsonAdapter.FACTORY);
        BUILT_IN_FACTORIES.add(ClassJsonAdapter.FACTORY);
    }

    static final class Lookup<T>
    extends JsonAdapter<T> {
        final Type type;
        @Nullable
        final String fieldName;
        final Object cacheKey;
        @Nullable
        JsonAdapter<T> adapter;

        Lookup(Type type, @Nullable String fieldName, Object cacheKey) {
            this.type = type;
            this.fieldName = fieldName;
            this.cacheKey = cacheKey;
        }

        @Override
        public T fromJson(JsonReader reader) throws IOException {
            if (this.adapter == null) {
                throw new IllegalStateException("JsonAdapter isn't ready");
            }
            return this.adapter.fromJson(reader);
        }

        @Override
        public void toJson(JsonWriter writer, T value) throws IOException {
            if (this.adapter == null) {
                throw new IllegalStateException("JsonAdapter isn't ready");
            }
            this.adapter.toJson(writer, value);
        }

        public String toString() {
            return this.adapter != null ? this.adapter.toString() : super.toString();
        }
    }

    final class LookupChain {
        final List<Lookup<?>> callLookups = new ArrayList();
        final Deque<Lookup<?>> stack = new ArrayDeque();
        boolean exceptionAnnotated;

        LookupChain() {
        }

        <T> JsonAdapter<T> push(Type type, @Nullable String fieldName, Object cacheKey) {
            int size = this.callLookups.size();
            for (int i = 0; i < size; ++i) {
                Lookup<?> lookup = this.callLookups.get(i);
                if (!lookup.cacheKey.equals(cacheKey)) continue;
                Lookup<?> hit = lookup;
                this.stack.add(hit);
                return hit.adapter != null ? hit.adapter : hit;
            }
            Lookup lookup = new Lookup(type, fieldName, cacheKey);
            this.callLookups.add(lookup);
            this.stack.add(lookup);
            return null;
        }

        <T> void adapterFound(JsonAdapter<T> result) {
            Lookup<?> currentLookup = this.stack.getLast();
            currentLookup.adapter = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void pop(boolean success) {
            this.stack.removeLast();
            if (!this.stack.isEmpty()) {
                return;
            }
            Moshi.this.lookupChainThreadLocal.remove();
            if (success) {
                Map map = Moshi.this.adapterCache;
                synchronized (map) {
                    int size = this.callLookups.size();
                    for (int i = 0; i < size; ++i) {
                        Lookup<?> lookup = this.callLookups.get(i);
                        JsonAdapter replaced = Moshi.this.adapterCache.put(lookup.cacheKey, lookup.adapter);
                        if (replaced == null) continue;
                        lookup.adapter = replaced;
                        Moshi.this.adapterCache.put(lookup.cacheKey, replaced);
                    }
                }
            }
        }

        IllegalArgumentException exceptionWithLookupStack(IllegalArgumentException e) {
            if (this.exceptionAnnotated) {
                return e;
            }
            this.exceptionAnnotated = true;
            int size = this.stack.size();
            if (size == 1 && this.stack.getFirst().fieldName == null) {
                return e;
            }
            StringBuilder errorMessageBuilder = new StringBuilder(e.getMessage());
            Iterator<Lookup<?>> i = this.stack.descendingIterator();
            while (i.hasNext()) {
                Lookup<?> lookup = i.next();
                errorMessageBuilder.append("\nfor ").append(lookup.type);
                if (lookup.fieldName == null) continue;
                errorMessageBuilder.append(' ').append(lookup.fieldName);
            }
            return new IllegalArgumentException(errorMessageBuilder.toString(), e);
        }
    }

    public static final class Builder {
        final List<JsonAdapter.Factory> factories = new ArrayList<JsonAdapter.Factory>();

        public <T> Builder add(final Type type, final JsonAdapter<T> jsonAdapter) {
            if (type == null) {
                throw new IllegalArgumentException("type == null");
            }
            if (jsonAdapter == null) {
                throw new IllegalArgumentException("jsonAdapter == null");
            }
            return this.add(new JsonAdapter.Factory(){

                @Override
                @Nullable
                public JsonAdapter<?> create(Type targetType, Set<? extends Annotation> annotations, Moshi moshi) {
                    return annotations.isEmpty() && Util.typesMatch(type, targetType) ? jsonAdapter : null;
                }
            });
        }

        public <T> Builder add(final Type type, final Class<? extends Annotation> annotation, final JsonAdapter<T> jsonAdapter) {
            if (type == null) {
                throw new IllegalArgumentException("type == null");
            }
            if (annotation == null) {
                throw new IllegalArgumentException("annotation == null");
            }
            if (jsonAdapter == null) {
                throw new IllegalArgumentException("jsonAdapter == null");
            }
            if (!annotation.isAnnotationPresent(JsonQualifier.class)) {
                throw new IllegalArgumentException(annotation + " does not have @JsonQualifier");
            }
            if (annotation.getDeclaredMethods().length > 0) {
                throw new IllegalArgumentException("Use JsonAdapter.Factory for annotations with elements");
            }
            return this.add(new JsonAdapter.Factory(){

                @Override
                @Nullable
                public JsonAdapter<?> create(Type targetType, Set<? extends Annotation> annotations, Moshi moshi) {
                    if (Util.typesMatch(type, targetType) && annotations.size() == 1 && Util.isAnnotationPresent(annotations, annotation)) {
                        return jsonAdapter;
                    }
                    return null;
                }
            });
        }

        public Builder add(JsonAdapter.Factory factory) {
            if (factory == null) {
                throw new IllegalArgumentException("factory == null");
            }
            this.factories.add(factory);
            return this;
        }

        public Builder add(Object adapter) {
            if (adapter == null) {
                throw new IllegalArgumentException("adapter == null");
            }
            return this.add(AdapterMethodsFactory.get(adapter));
        }

        Builder addAll(List<JsonAdapter.Factory> factories) {
            this.factories.addAll(factories);
            return this;
        }

        @CheckReturnValue
        public Moshi build() {
            return new Moshi(this);
        }
    }
}

