/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.SelectQueryImpl;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.SelectSubQueryImpl;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.Selection;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.SelectionCoreImpl;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.SelectionSubQueryImpl;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.WithInto;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.clauses.MultipleFromClause;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.clauses.OperationClause;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.clauses.RawFromClause;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.clauses.SimpleClause;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.clauses.SimpleFromClause;

public class SelectionQueryImpl
implements Selection,
WithInto {
    private final SelectionCoreImpl selectionCore;
    private boolean requiresPost;

    SelectionQueryImpl(SelectionCoreImpl selectionCore) {
        this.selectionCore = selectionCore;
    }

    @Override
    public SelectionQueryImpl distinct() {
        this.selectionCore.distinct();
        return this;
    }

    public SelectionQueryImpl requiresPost() {
        this.requiresPost = true;
        return this;
    }

    @Override
    public SelectionQueryImpl as(String aliasName) {
        this.selectionCore.as(aliasName);
        return this;
    }

    @Override
    public SelectionQueryImpl all() {
        this.selectionCore.all();
        return this;
    }

    @Override
    public SelectionQueryImpl countAll() {
        this.selectionCore.countAll();
        return this;
    }

    @Override
    public SelectionQueryImpl column(String name) {
        this.selectionCore.column(name);
        return this;
    }

    @Override
    public SelectionQueryImpl regex(String clause) {
        this.selectionCore.regex(clause);
        return this;
    }

    @Override
    public SelectionQueryImpl function(String name, Object ... parameters) {
        this.selectionCore.function(name, parameters);
        return this;
    }

    @Override
    public SelectionQueryImpl raw(String text) {
        this.selectionCore.raw(text);
        return this;
    }

    @Override
    public SelectionQueryImpl count(Object column) {
        this.selectionCore.count(column);
        return this;
    }

    @Override
    public SelectionQueryImpl max(Object column) {
        this.selectionCore.max(column);
        return this;
    }

    @Override
    public SelectionQueryImpl min(Object column) {
        this.selectionCore.min(column);
        return this;
    }

    @Override
    public SelectionQueryImpl sum(Object column) {
        this.selectionCore.sum(column);
        return this;
    }

    @Override
    public SelectionQueryImpl mean(Object column) {
        this.selectionCore.mean(column);
        return this;
    }

    @Override
    public SelectionQueryImpl into(String measurement) {
        this.selectionCore.into(measurement);
        return this;
    }

    @Override
    public SelectionQueryImpl op(OperationClause operationClause) {
        this.selectionCore.op(operationClause);
        return this;
    }

    @Override
    public SelectionQueryImpl op(Object arg1, String op, Object arg2) {
        this.selectionCore.op(arg1, op, arg2);
        return this;
    }

    @Override
    public SelectionQueryImpl cop(SimpleClause simpleClause) {
        this.selectionCore.cop(simpleClause);
        return this;
    }

    @Override
    public SelectionQueryImpl cop(String column, String op, Object arg2) {
        this.selectionCore.cop(column, op, arg2);
        return this;
    }

    public SelectQueryImpl from(String database, String table) {
        SelectQueryImpl selectQuery = new SelectQueryImpl(database, new SimpleFromClause(table), this.requiresPost, this.selectionCore);
        return selectQuery;
    }

    public SelectQueryImpl from(String database, String[] table) {
        if (table == null) {
            throw new IllegalArgumentException("Tables names should be specified");
        }
        SelectQueryImpl selectQuery = new SelectQueryImpl(database, new MultipleFromClause(Arrays.asList(table)), this.requiresPost, this.selectionCore);
        return selectQuery;
    }

    public SelectQueryImpl fromRaw(String database, String text) {
        SelectQueryImpl selectQuery = new SelectQueryImpl(database, new RawFromClause(text), this.requiresPost, this.selectionCore);
        return selectQuery;
    }

    public SelectQueryImpl from(String database) {
        SelectQueryImpl selectQuery = new SelectQueryImpl(database, this.requiresPost, this.selectionCore);
        return selectQuery;
    }

    public SelectSubQueryImpl<SelectQueryImpl> fromSubQuery(String database, String table) {
        SelectSubQueryImpl<SelectQueryImpl> subSelect = new SelectSubQueryImpl<SelectQueryImpl>(new SimpleFromClause(table), new ArrayList<Object>(), this.selectionCore.isDistinct);
        subSelect.setParent(this.from(database));
        return subSelect;
    }

    public SelectSubQueryImpl<SelectQueryImpl> fromSubQuery(String database, String[] tables) {
        SelectSubQueryImpl<SelectQueryImpl> subSelect = new SelectSubQueryImpl<SelectQueryImpl>(new MultipleFromClause(Arrays.asList(tables)), new ArrayList<Object>(), this.selectionCore.isDistinct);
        subSelect.setParent(this.from(database));
        return subSelect;
    }

    public SelectSubQueryImpl<SelectQueryImpl> fromSubQueryRaw(String database, String text) {
        SelectSubQueryImpl<SelectQueryImpl> subSelect = new SelectSubQueryImpl<SelectQueryImpl>(new RawFromClause(text), new ArrayList<Object>(), this.selectionCore.isDistinct);
        subSelect.setParent(this.from(database));
        return subSelect;
    }

    public SelectionSubQueryImpl<SelectQueryImpl> fromSubQuery(String database) {
        SelectQueryImpl selectQuery = this.from(database);
        return new SelectionSubQueryImpl<SelectQueryImpl>(selectQuery);
    }
}

