/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder;

import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.BuiltQuery;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.Ordering;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.QueryStringBuilder;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.SelectCoreImpl;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.SelectWithSubquery;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.SelectionCoreImpl;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.WhereCoreImpl;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.WhereQueryImpl;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.clauses.Clause;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.clauses.FromClause;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.querybuilder.clauses.RawTextClause;

public class SelectQueryImpl
extends BuiltQuery
implements SelectWithSubquery {
    private final SelectCoreImpl<WhereQueryImpl> selectCore;

    SelectQueryImpl(String database, boolean requiresPost, SelectionCoreImpl selectionCore) {
        super(database, requiresPost);
        WhereCoreImpl<SelectQueryImpl> whereCore = new WhereCoreImpl<SelectQueryImpl>(this);
        WhereQueryImpl<SelectQueryImpl> whereQuery = new WhereQueryImpl<SelectQueryImpl>(this, whereCore);
        this.selectCore = selectionCore.from(whereQuery);
    }

    SelectQueryImpl(String database, FromClause fromClause, boolean requiresPost, SelectionCoreImpl selectionCore) {
        super(database, requiresPost);
        WhereCoreImpl<SelectQueryImpl> whereCore = new WhereCoreImpl<SelectQueryImpl>(this);
        WhereQueryImpl<SelectQueryImpl> whereQuery = new WhereQueryImpl<SelectQueryImpl>(this, whereCore);
        this.selectCore = selectionCore.from(fromClause, whereQuery);
    }

    @Override
    public StringBuilder buildQueryString() {
        return this.selectCore.buildQueryString(new StringBuilder());
    }

    @Override
    public StringBuilder buildQueryString(StringBuilder stringBuilder) {
        return this.selectCore.buildQueryString(stringBuilder);
    }

    @Override
    public void setSubQuery(QueryStringBuilder query) {
        this.selectCore.setSubQuery(query);
    }

    public WhereQueryImpl<SelectQueryImpl> where() {
        return this.selectCore.where();
    }

    public WhereQueryImpl<SelectQueryImpl> where(Clause clause) {
        return this.selectCore.where().and(clause);
    }

    public WhereQueryImpl where(String text) {
        return this.selectCore.where().and(new RawTextClause(text));
    }

    public SelectQueryImpl orderBy(Ordering ordering) {
        this.selectCore.orderBy(ordering);
        return this;
    }

    public SelectQueryImpl groupBy(Object ... columns) {
        this.selectCore.groupBy(columns);
        return this;
    }

    public SelectQueryImpl fill(Number value) {
        this.selectCore.fill(value);
        return this;
    }

    public SelectQueryImpl fill(String value) {
        this.selectCore.fill(value);
        return this;
    }

    public SelectQueryImpl limit(int limit) {
        this.selectCore.limit(limit);
        return this;
    }

    public SelectQueryImpl limit(int limit, long offSet) {
        this.selectCore.limit(limit, offSet);
        return this;
    }

    public SelectQueryImpl sLimit(int sLimit) {
        this.selectCore.sLimit(sLimit);
        return this;
    }

    public SelectQueryImpl sLimit(int sLimit, long sOffSet) {
        this.selectCore.sLimit(sLimit, sOffSet);
        return this;
    }

    public SelectQueryImpl tz(String timezone) {
        this.selectCore.tz(timezone);
        return this;
    }
}

