/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.influxdb.shaded.org.influxdb.impl;

import java.lang.reflect.Field;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.InfluxDBMapperException;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.annotation.Column;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.annotation.Measurement;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.dto.QueryResult;

public class InfluxDBResultMapper {
    private static final ConcurrentMap<String, ConcurrentMap<String, Field>> CLASS_FIELD_CACHE = new ConcurrentHashMap<String, ConcurrentMap<String, Field>>();
    private static final int FRACTION_MIN_WIDTH = 0;
    private static final int FRACTION_MAX_WIDTH = 9;
    private static final boolean ADD_DECIMAL_POINT = true;
    private static final DateTimeFormatter RFC3339_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).appendZoneOrOffsetId().toFormatter();

    public <T> List<T> toPOJO(QueryResult queryResult, Class<T> clazz) throws InfluxDBMapperException {
        return this.toPOJO(queryResult, clazz, TimeUnit.MILLISECONDS);
    }

    public <T> List<T> toPOJO(QueryResult queryResult, Class<T> clazz, TimeUnit precision) throws InfluxDBMapperException {
        this.throwExceptionIfMissingAnnotation(clazz);
        String measurementName = this.getMeasurementName(clazz);
        return this.toPOJO(queryResult, clazz, measurementName, precision);
    }

    public <T> List<T> toPOJO(QueryResult queryResult, Class<T> clazz, String measurementName) throws InfluxDBMapperException {
        return this.toPOJO(queryResult, clazz, measurementName, TimeUnit.MILLISECONDS);
    }

    public <T> List<T> toPOJO(QueryResult queryResult, Class<T> clazz, String measurementName, TimeUnit precision) throws InfluxDBMapperException {
        Objects.requireNonNull(measurementName, "measurementName");
        Objects.requireNonNull(queryResult, "queryResult");
        Objects.requireNonNull(clazz, "clazz");
        this.throwExceptionIfResultWithError(queryResult);
        this.cacheMeasurementClass(clazz);
        LinkedList result = new LinkedList();
        queryResult.getResults().stream().filter(internalResult -> Objects.nonNull(internalResult) && Objects.nonNull(internalResult.getSeries())).forEach(internalResult -> internalResult.getSeries().stream().filter(series -> series.getName().equals(measurementName)).forEachOrdered(series -> this.parseSeriesAs((QueryResult.Series)series, clazz, result, precision)));
        return result;
    }

    void throwExceptionIfMissingAnnotation(Class<?> clazz) {
        if (!clazz.isAnnotationPresent(Measurement.class)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is not annotated with @" + Measurement.class.getSimpleName());
        }
    }

    void throwExceptionIfResultWithError(QueryResult queryResult) {
        if (queryResult.getError() != null) {
            throw new InfluxDBMapperException("InfluxDB returned an error: " + queryResult.getError());
        }
        queryResult.getResults().forEach(seriesResult -> {
            if (seriesResult.getError() != null) {
                throw new InfluxDBMapperException("InfluxDB returned an error with Series: " + seriesResult.getError());
            }
        });
    }

    ConcurrentMap<String, Field> getColNameAndFieldMap(Class<?> clazz) {
        return (ConcurrentMap)CLASS_FIELD_CACHE.get(clazz.getName());
    }

    void cacheMeasurementClass(Class<?> ... classVarAgrs) {
        for (Class<?> clazz : classVarAgrs) {
            if (CLASS_FIELD_CACHE.containsKey(clazz.getName())) continue;
            ConcurrentHashMap<String, Field> initialMap = new ConcurrentHashMap<String, Field>();
            ConcurrentHashMap<String, Field> influxColumnAndFieldMap = CLASS_FIELD_CACHE.putIfAbsent(clazz.getName(), initialMap);
            if (influxColumnAndFieldMap == null) {
                influxColumnAndFieldMap = initialMap;
            }
            for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
                for (Field field : c.getDeclaredFields()) {
                    Column colAnnotation = field.getAnnotation(Column.class);
                    if (colAnnotation == null) continue;
                    influxColumnAndFieldMap.put(colAnnotation.name(), field);
                }
            }
        }
    }

    String getMeasurementName(Class<?> clazz) {
        return clazz.getAnnotation(Measurement.class).name();
    }

    String getDatabaseName(Class<?> clazz) {
        return clazz.getAnnotation(Measurement.class).database();
    }

    String getRetentionPolicy(Class<?> clazz) {
        return clazz.getAnnotation(Measurement.class).retentionPolicy();
    }

    TimeUnit getTimeUnit(Class<?> clazz) {
        return clazz.getAnnotation(Measurement.class).timeUnit();
    }

    <T> List<T> parseSeriesAs(QueryResult.Series series, Class<T> clazz, List<T> result) {
        return this.parseSeriesAs(series, clazz, result, TimeUnit.MILLISECONDS);
    }

    <T> List<T> parseSeriesAs(QueryResult.Series series, Class<T> clazz, List<T> result, TimeUnit precision) {
        int columnSize = series.getColumns().size();
        ConcurrentMap colNameAndFieldMap = (ConcurrentMap)CLASS_FIELD_CACHE.get(clazz.getName());
        try {
            T object = null;
            for (List<Object> row : series.getValues()) {
                for (int i = 0; i < columnSize; ++i) {
                    Field correspondingField = (Field)colNameAndFieldMap.get(series.getColumns().get(i));
                    if (correspondingField == null) continue;
                    if (object == null) {
                        object = clazz.newInstance();
                    }
                    this.setFieldValue(object, correspondingField, row.get(i), precision);
                }
                if (series.getTags() != null && !series.getTags().isEmpty()) {
                    for (Map.Entry<String, String> entry : series.getTags().entrySet()) {
                        Field correspondingField = (Field)colNameAndFieldMap.get(entry.getKey());
                        if (correspondingField == null) continue;
                        this.setFieldValue(object, correspondingField, entry.getValue(), precision);
                    }
                }
                if (object == null) continue;
                result.add(object);
                object = null;
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new InfluxDBMapperException(e);
        }
        return result;
    }

    <T> void setFieldValue(T object, Field field, Object value, TimeUnit precision) throws IllegalArgumentException, IllegalAccessException {
        if (value == null) {
            return;
        }
        Class<?> fieldType = field.getType();
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (this.fieldValueModified(fieldType, field, object, value, precision) || this.fieldValueForPrimitivesModified(fieldType, field, object, value) || this.fieldValueForPrimitiveWrappersModified(fieldType, field, object, value)) {
                return;
            }
            String msg = "Class '%s' field '%s' is from an unsupported type '%s'.";
            throw new InfluxDBMapperException(String.format(msg, object.getClass().getName(), field.getName(), field.getType()));
        }
        catch (ClassCastException e) {
            String msg = "Class '%s' field '%s' was defined with a different field type and caused a ClassCastException. The correct type is '%s' (current field value: '%s').";
            throw new InfluxDBMapperException(String.format(msg, object.getClass().getName(), field.getName(), value.getClass().getName(), value));
        }
    }

    <T> boolean fieldValueModified(Class<?> fieldType, Field field, T object, Object value, TimeUnit precision) throws IllegalArgumentException, IllegalAccessException {
        if (String.class.isAssignableFrom(fieldType)) {
            field.set(object, String.valueOf(value));
            return true;
        }
        if (Instant.class.isAssignableFrom(fieldType)) {
            Instant instant;
            if (value instanceof String) {
                instant = Instant.from(RFC3339_FORMATTER.parse(String.valueOf(value)));
            } else if (value instanceof Long) {
                instant = Instant.ofEpochMilli(this.toMillis((Long)value, precision));
            } else if (value instanceof Double) {
                instant = Instant.ofEpochMilli(this.toMillis(((Double)value).longValue(), precision));
            } else if (value instanceof Integer) {
                instant = Instant.ofEpochMilli(this.toMillis(((Integer)value).longValue(), precision));
            } else {
                throw new InfluxDBMapperException("Unsupported type " + field.getClass() + " for field " + field.getName());
            }
            field.set(object, instant);
            return true;
        }
        return false;
    }

    <T> boolean fieldValueForPrimitivesModified(Class<?> fieldType, Field field, T object, Object value) throws IllegalArgumentException, IllegalAccessException {
        if (Double.TYPE.isAssignableFrom(fieldType)) {
            field.setDouble(object, (Double)value);
            return true;
        }
        if (Long.TYPE.isAssignableFrom(fieldType)) {
            field.setLong(object, ((Double)value).longValue());
            return true;
        }
        if (Integer.TYPE.isAssignableFrom(fieldType)) {
            field.setInt(object, ((Double)value).intValue());
            return true;
        }
        if (Boolean.TYPE.isAssignableFrom(fieldType)) {
            field.setBoolean(object, Boolean.valueOf(String.valueOf(value)));
            return true;
        }
        return false;
    }

    <T> boolean fieldValueForPrimitiveWrappersModified(Class<?> fieldType, Field field, T object, Object value) throws IllegalArgumentException, IllegalAccessException {
        if (Double.class.isAssignableFrom(fieldType)) {
            field.set(object, value);
            return true;
        }
        if (Long.class.isAssignableFrom(fieldType)) {
            field.set(object, ((Double)value).longValue());
            return true;
        }
        if (Integer.class.isAssignableFrom(fieldType)) {
            field.set(object, ((Double)value).intValue());
            return true;
        }
        if (Boolean.class.isAssignableFrom(fieldType)) {
            field.set(object, Boolean.valueOf(String.valueOf(value)));
            return true;
        }
        return false;
    }

    private Long toMillis(long value, TimeUnit precision) {
        return TimeUnit.MILLISECONDS.convert(value, precision);
    }
}

