/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.influxdb.shaded.org.influxdb.impl;

import java.lang.reflect.Field;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.InfluxDB;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.InfluxDBMapperException;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.annotation.Column;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.annotation.Measurement;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.dto.Point;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.dto.Query;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.dto.QueryResult;
import org.apache.flink.metrics.influxdb.shaded.org.influxdb.impl.InfluxDBResultMapper;

public class InfluxDBMapper
extends InfluxDBResultMapper {
    private final InfluxDB influxDB;

    public InfluxDBMapper(InfluxDB influxDB) {
        this.influxDB = influxDB;
    }

    public <T> List<T> query(Query query, Class<T> clazz) {
        this.throwExceptionIfMissingAnnotation(clazz);
        QueryResult queryResult = this.influxDB.query(query);
        return this.toPOJO(queryResult, clazz);
    }

    public <T> List<T> query(Class<T> clazz) {
        this.throwExceptionIfMissingAnnotation(clazz);
        String measurement = this.getMeasurementName(clazz);
        String database = this.getDatabaseName(clazz);
        if ("[unassigned]".equals(database)) {
            throw new IllegalArgumentException(Measurement.class.getSimpleName() + " of class " + clazz.getName() + " should specify a database value for this operation");
        }
        QueryResult queryResult = this.influxDB.query(new Query("SELECT * FROM " + measurement, database));
        return this.toPOJO(queryResult, clazz);
    }

    public <T> void save(T model) {
        this.throwExceptionIfMissingAnnotation(model.getClass());
        this.cacheMeasurementClass(model.getClass());
        ConcurrentMap<String, Field> colNameAndFieldMap = this.getColNameAndFieldMap(model.getClass());
        try {
            Class<?> modelType = model.getClass();
            String measurement = this.getMeasurementName(modelType);
            String database = this.getDatabaseName(modelType);
            String retentionPolicy = this.getRetentionPolicy(modelType);
            TimeUnit timeUnit = this.getTimeUnit(modelType);
            long time = timeUnit.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            Point.Builder pointBuilder = Point.measurement(measurement).time(time, timeUnit);
            for (String key : colNameAndFieldMap.keySet()) {
                Field field = (Field)colNameAndFieldMap.get(key);
                Column column = field.getAnnotation(Column.class);
                String columnName = column.name();
                Class<?> fieldType = field.getType();
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                Object value = field.get(model);
                if (column.tag()) {
                    pointBuilder.tag(columnName, value.toString());
                    continue;
                }
                if ("time".equals(columnName)) {
                    if (value == null) continue;
                    this.setTime(pointBuilder, fieldType, timeUnit, value);
                    continue;
                }
                this.setField(pointBuilder, fieldType, columnName, value);
            }
            Point point = pointBuilder.build();
            if ("[unassigned]".equals(database)) {
                this.influxDB.write(point);
            } else {
                this.influxDB.write(database, retentionPolicy, point);
            }
        }
        catch (IllegalAccessException e) {
            throw new InfluxDBMapperException(e);
        }
    }

    private void setTime(Point.Builder pointBuilder, Class<?> fieldType, TimeUnit timeUnit, Object value) {
        if (!Instant.class.isAssignableFrom(fieldType)) {
            throw new InfluxDBMapperException("Unsupported type " + fieldType + " for time: should be of Instant type");
        }
        Instant instant = (Instant)value;
        long time = timeUnit.convert(instant.toEpochMilli(), TimeUnit.MILLISECONDS);
        pointBuilder.time(time, timeUnit);
    }

    private void setField(Point.Builder pointBuilder, Class<?> fieldType, String columnName, Object value) {
        if (Boolean.TYPE.isAssignableFrom(fieldType) || Boolean.class.isAssignableFrom(fieldType)) {
            pointBuilder.addField(columnName, (Boolean)value);
        } else if (Long.TYPE.isAssignableFrom(fieldType) || Long.class.isAssignableFrom(fieldType)) {
            pointBuilder.addField(columnName, (Long)value);
        } else if (Double.TYPE.isAssignableFrom(fieldType) || Double.class.isAssignableFrom(fieldType)) {
            pointBuilder.addField(columnName, (Double)value);
        } else if (Integer.TYPE.isAssignableFrom(fieldType) || Integer.class.isAssignableFrom(fieldType)) {
            pointBuilder.addField(columnName, ((Integer)value).intValue());
        } else if (String.class.isAssignableFrom(fieldType)) {
            pointBuilder.addField(columnName, (String)value);
        } else {
            throw new InfluxDBMapperException("Unsupported type " + fieldType + " for column " + columnName);
        }
    }
}

