/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.influxdb.shaded.okhttp3.internal.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.metrics.influxdb.shaded.okhttp3.Challenge;
import org.apache.flink.metrics.influxdb.shaded.okhttp3.Cookie;
import org.apache.flink.metrics.influxdb.shaded.okhttp3.CookieJar;
import org.apache.flink.metrics.influxdb.shaded.okhttp3.Headers;
import org.apache.flink.metrics.influxdb.shaded.okhttp3.HttpUrl;
import org.apache.flink.metrics.influxdb.shaded.okhttp3.Request;
import org.apache.flink.metrics.influxdb.shaded.okhttp3.Response;
import org.apache.flink.metrics.influxdb.shaded.okhttp3.internal.Util;

public final class HttpHeaders {
    private static final String TOKEN = "([^ \"=]*)";
    private static final String QUOTED_STRING = "\"([^\"]*)\"";
    private static final Pattern PARAMETER = Pattern.compile(" +([^ \"=]*)=(:?\"([^\"]*)\"|([^ \"=]*)) *(:?,|$)");

    private HttpHeaders() {
    }

    public static long contentLength(Response response) {
        return HttpHeaders.contentLength(response.headers());
    }

    public static long contentLength(Headers headers) {
        return HttpHeaders.stringToLong(headers.get("Content-Length"));
    }

    private static long stringToLong(String s) {
        if (s == null) {
            return -1L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static boolean varyMatches(Response cachedResponse, Headers cachedRequest, Request newRequest) {
        for (String field : HttpHeaders.varyFields(cachedResponse)) {
            if (Util.equal(cachedRequest.values(field), newRequest.headers(field))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasVaryAll(Response response) {
        return HttpHeaders.hasVaryAll(response.headers());
    }

    public static boolean hasVaryAll(Headers responseHeaders) {
        return HttpHeaders.varyFields(responseHeaders).contains("*");
    }

    private static Set<String> varyFields(Response response) {
        return HttpHeaders.varyFields(response.headers());
    }

    public static Set<String> varyFields(Headers responseHeaders) {
        Set<String> result = Collections.emptySet();
        int size = responseHeaders.size();
        for (int i = 0; i < size; ++i) {
            if (!"Vary".equalsIgnoreCase(responseHeaders.name(i))) continue;
            String value = responseHeaders.value(i);
            if (result.isEmpty()) {
                result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            }
            for (String varyField : value.split(",")) {
                result.add(varyField.trim());
            }
        }
        return result;
    }

    public static Headers varyHeaders(Response response) {
        Headers requestHeaders = response.networkResponse().request().headers();
        Headers responseHeaders = response.headers();
        return HttpHeaders.varyHeaders(requestHeaders, responseHeaders);
    }

    public static Headers varyHeaders(Headers requestHeaders, Headers responseHeaders) {
        Set<String> varyFields = HttpHeaders.varyFields(responseHeaders);
        if (varyFields.isEmpty()) {
            return new Headers.Builder().build();
        }
        Headers.Builder result = new Headers.Builder();
        int size = requestHeaders.size();
        for (int i = 0; i < size; ++i) {
            String fieldName = requestHeaders.name(i);
            if (!varyFields.contains(fieldName)) continue;
            result.add(fieldName, requestHeaders.value(i));
        }
        return result.build();
    }

    public static List<Challenge> parseChallenges(Headers responseHeaders, String challengeHeader) {
        ArrayList<Challenge> challenges = new ArrayList<Challenge>();
        List<String> authenticationHeaders = responseHeaders.values(challengeHeader);
        for (String header : authenticationHeaders) {
            int index = header.indexOf(32);
            if (index == -1) continue;
            String scheme = header.substring(0, index);
            String realm = null;
            String charset = null;
            Matcher matcher = PARAMETER.matcher(header);
            int i = index;
            while (matcher.find(i)) {
                if (header.regionMatches(true, matcher.start(1), "realm", 0, 5)) {
                    realm = matcher.group(3);
                } else if (header.regionMatches(true, matcher.start(1), "charset", 0, 7)) {
                    charset = matcher.group(3);
                }
                if (realm != null && charset != null) break;
                i = matcher.end();
            }
            if (realm == null) continue;
            Challenge challenge = new Challenge(scheme, realm);
            if (charset != null) {
                if (!charset.equalsIgnoreCase("UTF-8")) continue;
                challenge = challenge.withCharset(Util.UTF_8);
            }
            challenges.add(challenge);
        }
        return challenges;
    }

    public static void receiveHeaders(CookieJar cookieJar, HttpUrl url, Headers headers) {
        if (cookieJar == CookieJar.NO_COOKIES) {
            return;
        }
        List<Cookie> cookies = Cookie.parseAll(url, headers);
        if (cookies.isEmpty()) {
            return;
        }
        cookieJar.saveFromResponse(url, cookies);
    }

    public static boolean hasBody(Response response) {
        if (response.request().method().equals("HEAD")) {
            return false;
        }
        int responseCode = response.code();
        if ((responseCode < 100 || responseCode >= 200) && responseCode != 204 && responseCode != 304) {
            return true;
        }
        return HttpHeaders.contentLength(response) != -1L || "chunked".equalsIgnoreCase(response.header("Transfer-Encoding"));
    }

    public static int skipUntil(String input, int pos, String characters) {
        while (pos < input.length() && characters.indexOf(input.charAt(pos)) == -1) {
            ++pos;
        }
        return pos;
    }

    public static int skipWhitespace(String input, int pos) {
        char c;
        while (pos < input.length() && ((c = input.charAt(pos)) == ' ' || c == '\t')) {
            ++pos;
        }
        return pos;
    }

    public static int parseSeconds(String value, int defaultValue) {
        try {
            long seconds = Long.parseLong(value);
            if (seconds > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (seconds < 0L) {
                return 0;
            }
            return (int)seconds;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

