/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.datadog;

import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.datadog.DCounter;
import org.apache.flink.metrics.datadog.DGauge;
import org.apache.flink.metrics.datadog.DMeter;
import org.apache.flink.metrics.datadog.DSeries;
import org.apache.flink.metrics.datadog.DatadogHttpClient;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.apache.flink.metrics.reporter.Scheduled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatadogHttpReporter
implements MetricReporter,
Scheduled {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatadogHttpReporter.class);
    private static final String HOST_VARIABLE = "<host>";
    private final Map<Gauge, DGauge> gauges = new ConcurrentHashMap<Gauge, DGauge>();
    private final Map<Counter, DCounter> counters = new ConcurrentHashMap<Counter, DCounter>();
    private final Map<Meter, DMeter> meters = new ConcurrentHashMap<Meter, DMeter>();
    private DatadogHttpClient client;
    private List<String> configTags;
    public static final String API_KEY = "apikey";
    public static final String TAGS = "tags";

    public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
        String name = group.getMetricIdentifier(metricName);
        ArrayList<String> tags = new ArrayList<String>(this.configTags);
        tags.addAll(this.getTagsFromMetricGroup(group));
        String host = this.getHostFromMetricGroup(group);
        if (metric instanceof Counter) {
            Counter c = (Counter)metric;
            this.counters.put(c, new DCounter(c, name, host, tags));
        } else if (metric instanceof Gauge) {
            Gauge g = (Gauge)metric;
            this.gauges.put(g, new DGauge((Gauge<Number>)g, name, host, tags));
        } else if (metric instanceof Meter) {
            Meter m = (Meter)metric;
            this.meters.put(m, new DMeter(m, name, host, tags));
        } else if (metric instanceof Histogram) {
            LOGGER.warn("Cannot add {} because Datadog HTTP API doesn't support Histogram", (Object)metricName);
        } else {
            LOGGER.warn("Cannot add unknown metric type {}. This indicates that the reporter does not support this metric type.", (Object)metric.getClass().getName());
        }
    }

    public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
        if (metric instanceof Counter) {
            this.counters.remove(metric);
        } else if (metric instanceof Gauge) {
            this.gauges.remove(metric);
        } else if (metric instanceof Meter) {
            this.meters.remove(metric);
        } else if (!(metric instanceof Histogram)) {
            LOGGER.warn("Cannot remove unknown metric type {}. This indicates that the reporter does not support this metric type.", (Object)metric.getClass().getName());
        }
    }

    public void open(MetricConfig config) {
        this.client = new DatadogHttpClient(config.getString(API_KEY, null));
        LOGGER.info("Configured DatadogHttpReporter");
        this.configTags = this.getTagsFromConfig(config.getString(TAGS, ""));
    }

    public void close() {
        this.client.close();
        LOGGER.info("Shut down DatadogHttpReporter");
    }

    public void report() {
        DatadogHttpRequest request = new DatadogHttpRequest();
        for (Map.Entry<Gauge, DGauge> entry : this.gauges.entrySet()) {
            DGauge g = entry.getValue();
            try {
                g.getMetricValue();
                request.addGauge(g);
            }
            catch (Exception e) {
                this.gauges.remove(entry.getKey());
            }
        }
        for (DCounter c : this.counters.values()) {
            request.addCounter(c);
        }
        for (DMeter m : this.meters.values()) {
            request.addMeter(m);
        }
        try {
            this.client.send(request);
        }
        catch (SocketTimeoutException e) {
            LOGGER.warn("Failed reporting metrics to Datadog because of socket timeout.", (Object)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.warn("Failed reporting metrics to Datadog.", (Throwable)e);
        }
    }

    private List<String> getTagsFromConfig(String str) {
        return Arrays.asList(str.split(","));
    }

    private List<String> getTagsFromMetricGroup(MetricGroup metricGroup) {
        ArrayList<String> tags = new ArrayList<String>();
        for (Map.Entry entry : metricGroup.getAllVariables().entrySet()) {
            if (((String)entry.getKey()).equals(HOST_VARIABLE)) continue;
            tags.add(this.getVariableName((String)entry.getKey()) + ":" + (String)entry.getValue());
        }
        return tags;
    }

    private String getHostFromMetricGroup(MetricGroup metricGroup) {
        return (String)metricGroup.getAllVariables().get(HOST_VARIABLE);
    }

    private String getVariableName(String str) {
        return str.substring(1, str.length() - 1);
    }

    static class DatadogHttpRequest {
        private final DSeries series = new DSeries();

        public void addGauge(DGauge gauge) {
            this.series.addMetric(gauge);
        }

        public void addCounter(DCounter counter) {
            this.series.addMetric(counter);
        }

        public void addMeter(DMeter meter) {
            this.series.addMetric(meter);
        }

        public DSeries getSeries() {
            return this.series;
        }
    }
}

