/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.datadog;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.flink.metrics.datadog.DatadogHttpReporter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.okhttp3.Call;
import org.apache.flink.shaded.okhttp3.Callback;
import org.apache.flink.shaded.okhttp3.MediaType;
import org.apache.flink.shaded.okhttp3.OkHttpClient;
import org.apache.flink.shaded.okhttp3.Request;
import org.apache.flink.shaded.okhttp3.RequestBody;
import org.apache.flink.shaded.okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatadogHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatadogHttpClient.class);
    private static final String SERIES_URL_FORMAT = "https://app.datadoghq.com/api/v1/series?api_key=%s";
    private static final String VALIDATE_URL_FORMAT = "https://app.datadoghq.com/api/v1/validate?api_key=%s";
    private static final MediaType MEDIA_TYPE = MediaType.parse("application/json; charset=utf-8");
    private static final int TIMEOUT = 3;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final String seriesUrl;
    private final String validateUrl;
    private final OkHttpClient client;
    private final String apiKey;

    public DatadogHttpClient(String dgApiKey) {
        if (dgApiKey == null || dgApiKey.isEmpty()) {
            throw new IllegalArgumentException("Invalid API key:" + dgApiKey);
        }
        this.apiKey = dgApiKey;
        this.client = new OkHttpClient.Builder().connectTimeout(3L, TimeUnit.SECONDS).writeTimeout(3L, TimeUnit.SECONDS).readTimeout(3L, TimeUnit.SECONDS).build();
        this.seriesUrl = String.format(SERIES_URL_FORMAT, this.apiKey);
        this.validateUrl = String.format(VALIDATE_URL_FORMAT, this.apiKey);
        this.validateApiKey();
    }

    private void validateApiKey() {
        Request r = new Request.Builder().url(this.validateUrl).get().build();
        try (Response response = this.client.newCall(r).execute();){
            if (!response.isSuccessful()) {
                throw new IllegalArgumentException(String.format("API key: %s is invalid", this.apiKey));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed contacting Datadog to validate API key", e);
        }
    }

    public void send(DatadogHttpReporter.DatadogHttpRequest request) throws Exception {
        String postBody = DatadogHttpClient.serialize(request.getSeries());
        Request r = new Request.Builder().url(this.seriesUrl).post(RequestBody.create(MEDIA_TYPE, postBody)).build();
        this.client.newCall(r).enqueue(EmptyCallback.getEmptyCallback());
    }

    public static String serialize(Object obj) throws JsonProcessingException {
        return MAPPER.writeValueAsString(obj);
    }

    public void close() {
        this.client.dispatcher().executorService().shutdown();
        this.client.connectionPool().evictAll();
    }

    private static class EmptyCallback
    implements Callback {
        private static final EmptyCallback singleton = new EmptyCallback();

        private EmptyCallback() {
        }

        public static Callback getEmptyCallback() {
            return singleton;
        }

        @Override
        public void onFailure(Call call, IOException e) {
            LOGGER.debug("Failed sending request to Datadog", (Throwable)e);
        }

        @Override
        public void onResponse(Call call, Response response) throws IOException {
            response.close();
        }
    }
}

