/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.datadog;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.flink.metrics.datadog.DatadogHttpReporter;

public class DatadogHttpClient {
    private static final String SERIES_URL_FORMAT = "https://app.datadoghq.com/api/v1/series?api_key=%s";
    private static final String VALIDATE_URL_FORMAT = "https://app.datadoghq.com/api/v1/validate?api_key=%s";
    private static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private static final int TIMEOUT = 3;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final String seriesUrl;
    private final String validateUrl;
    private final OkHttpClient client;
    private final String apiKey;

    public DatadogHttpClient(String dgApiKey) {
        if (dgApiKey == null || dgApiKey.isEmpty()) {
            throw new IllegalArgumentException("Invalid API key:" + dgApiKey);
        }
        this.apiKey = dgApiKey;
        this.client = new OkHttpClient.Builder().connectTimeout(3L, TimeUnit.SECONDS).writeTimeout(3L, TimeUnit.SECONDS).readTimeout(3L, TimeUnit.SECONDS).build();
        this.seriesUrl = String.format(SERIES_URL_FORMAT, this.apiKey);
        this.validateUrl = String.format(VALIDATE_URL_FORMAT, this.apiKey);
        this.validateApiKey();
    }

    private void validateApiKey() {
        Request r = new Request.Builder().url(this.validateUrl).get().build();
        try (Response response = this.client.newCall(r).execute();){
            if (!response.isSuccessful()) {
                throw new IllegalArgumentException(String.format("API key: %s is invalid", this.apiKey));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed contacting Datadog to validate API key", e);
        }
    }

    public void send(DatadogHttpReporter.DatadogHttpRequest request) throws Exception {
        String postBody = DatadogHttpClient.serialize(request.getSeries());
        Request r = new Request.Builder().url(this.seriesUrl).post(RequestBody.create((MediaType)MEDIA_TYPE, (String)postBody)).build();
        this.client.newCall(r).execute().close();
    }

    public static String serialize(Object obj) throws JsonProcessingException {
        return MAPPER.writeValueAsString(obj);
    }

    public void close() {
        this.client.dispatcher().executorService().shutdown();
        this.client.connectionPool().evictAll();
    }
}

