/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.datadog;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.metrics.datadog.MetricType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class DMetric {
    private static final long MILLIS_TO_SEC = 1000L;
    private final String metric;
    private final MetricType type;
    private final String host;
    private final List<String> tags;

    public DMetric(MetricType metricType, String metric, String host, List<String> tags) {
        this.type = metricType;
        this.metric = metric;
        this.host = host;
        this.tags = tags;
    }

    public MetricType getType() {
        return this.type;
    }

    public String getMetric() {
        return this.metric;
    }

    public String getHost() {
        return this.host;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<List<Number>> getPoints() {
        ArrayList<Number> point = new ArrayList<Number>();
        point.add(DMetric.getUnixEpochTimestamp());
        point.add(this.getMetricValue());
        ArrayList<List<Number>> points = new ArrayList<List<Number>>();
        points.add(point);
        return points;
    }

    @JsonIgnore
    public abstract Number getMetricValue();

    public static long getUnixEpochTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }
}

