/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.datadog;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.metrics.datadog.Clock;
import org.apache.flink.metrics.datadog.MetricType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class DMetric {
    private final String metric;
    private final MetricType type;
    private final String host;
    private final List<String> tags;
    private final Clock clock;

    public DMetric(MetricType metricType, String metric, String host, List<String> tags, Clock clock) {
        this.type = metricType;
        this.metric = metric;
        this.host = host;
        this.tags = tags;
        this.clock = clock;
    }

    public MetricType getType() {
        return this.type;
    }

    public String getMetric() {
        return this.metric;
    }

    public String getHost() {
        return this.host;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<List<Number>> getPoints() {
        ArrayList<Number> point = new ArrayList<Number>();
        point.add(this.clock.getUnixEpochTimestamp());
        point.add(this.getMetricValue());
        ArrayList<List<Number>> points = new ArrayList<List<Number>>();
        points.add(point);
        return points;
    }

    @JsonIgnore
    public abstract Number getMetricValue();

    public void ackReport() {
    }
}

