/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.datadog;

import java.util.List;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.datadog.Clock;
import org.apache.flink.metrics.datadog.DMetric;
import org.apache.flink.metrics.datadog.MetricType;

public class DCounter
extends DMetric {
    private final Counter counter;
    private long lastReportCount = 0L;
    private long currentReportCount = 0L;

    public DCounter(Counter c, String metricName, String host, List<String> tags, Clock clock) {
        super(MetricType.count, metricName, host, tags, clock);
        this.counter = c;
    }

    @Override
    public Number getMetricValue() {
        long currentCount = this.counter.getCount();
        long difference = currentCount - this.lastReportCount;
        this.currentReportCount = currentCount;
        return difference;
    }

    @Override
    public void ackReport() {
        this.lastReportCount = this.currentReportCount;
    }
}

