/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics;

import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.metrics.SimpleCounter;
import org.junit.Assert;
import org.junit.Test;

public class MeterViewTest {
    @Test
    public void testGetCount() {
        SimpleCounter c = new SimpleCounter();
        c.inc(5L);
        MeterView m = new MeterView((Counter)c, 60);
        Assert.assertEquals((long)5L, (long)m.getCount());
    }

    @Test
    public void testMarkEvent() {
        SimpleCounter c = new SimpleCounter();
        MeterView m = new MeterView((Counter)c, 60);
        Assert.assertEquals((long)0L, (long)m.getCount());
        m.markEvent();
        Assert.assertEquals((long)1L, (long)m.getCount());
        m.markEvent(2L);
        Assert.assertEquals((long)3L, (long)m.getCount());
    }

    @Test
    public void testGetRate() {
        int x;
        SimpleCounter c = new SimpleCounter();
        MeterView m = new MeterView((Counter)c, 60);
        for (x = 0; x < 12; ++x) {
            m.markEvent(10L);
            m.update();
        }
        Assert.assertEquals((double)2.0, (double)m.getRate(), (double)0.1);
        for (x = 0; x < 12; ++x) {
            m.markEvent(10L);
            m.update();
        }
        Assert.assertEquals((double)2.0, (double)m.getRate(), (double)0.1);
        for (x = 0; x < 6; ++x) {
            m.markEvent(20L);
            m.update();
        }
        Assert.assertEquals((double)3.0, (double)m.getRate(), (double)0.1);
        for (x = 0; x < 6; ++x) {
            m.markEvent(20L);
            m.update();
        }
        Assert.assertEquals((double)4.0, (double)m.getRate(), (double)0.1);
        for (x = 0; x < 6; ++x) {
            m.update();
        }
        Assert.assertEquals((double)2.0, (double)m.getRate(), (double)0.1);
        for (x = 0; x < 6; ++x) {
            m.update();
        }
        Assert.assertEquals((double)0.0, (double)m.getRate(), (double)0.1);
    }

    @Test
    public void testTimeSpanBelowUpdateRate() {
        int timeSpanInSeconds = 1;
        MeterView m = new MeterView(timeSpanInSeconds);
        assert (timeSpanInSeconds < 5);
        m.markEvent();
        m.update();
        Assert.assertEquals((double)0.2, (double)m.getRate(), (double)0.0);
    }
}

