/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics;

import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.metrics.View;

public class MeterView
implements Meter,
View {
    private final Counter counter;
    private final int timeSpanInSeconds;
    private final long[] values;
    private int time = 0;
    private double currentRate = 0.0;

    public MeterView(int timeSpanInSeconds) {
        this(new SimpleCounter(), timeSpanInSeconds);
    }

    public MeterView(Counter counter, int timeSpanInSeconds) {
        this.counter = counter;
        this.timeSpanInSeconds = Math.max(timeSpanInSeconds - timeSpanInSeconds % 5, 5);
        this.values = new long[this.timeSpanInSeconds / 5 + 1];
    }

    @Override
    public void markEvent() {
        this.counter.inc();
    }

    @Override
    public void markEvent(long n) {
        this.counter.inc(n);
    }

    @Override
    public long getCount() {
        return this.counter.getCount();
    }

    @Override
    public double getRate() {
        return this.currentRate;
    }

    @Override
    public void update() {
        this.time = (this.time + 1) % this.values.length;
        this.values[this.time] = this.counter.getCount();
        this.currentRate = (double)(this.values[this.time] - this.values[(this.time + 1) % this.values.length]) / (double)this.timeSpanInSeconds;
    }
}

