/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics;

import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.HistogramStatistics;
import org.assertj.core.api.Assertions;

public class AbstractHistogramTest {
    protected void testHistogram(int size, Histogram histogram) {
        HistogramStatistics statistics;
        int i;
        for (i = 0; i < size; ++i) {
            histogram.update((long)i);
            statistics = histogram.getStatistics();
            Assertions.assertThat((long)histogram.getCount()).isEqualTo((long)(i + 1));
            Assertions.assertThat((int)statistics.size()).isEqualTo(histogram.getCount());
            Assertions.assertThat((long)statistics.getMax()).isEqualTo((long)i);
            Assertions.assertThat((long)statistics.getMin()).isEqualTo(0L);
        }
        statistics = histogram.getStatistics();
        Assertions.assertThat((int)statistics.size()).isEqualTo(size);
        Assertions.assertThat((double)statistics.getQuantile(0.5)).isCloseTo((double)(size - 1) / 2.0, Assertions.offset((Double)0.001));
        for (i = size; i < 2 * size; ++i) {
            histogram.update((long)i);
            statistics = histogram.getStatistics();
            Assertions.assertThat((long)histogram.getCount()).isEqualTo((long)(i + 1));
            Assertions.assertThat((int)statistics.size()).isEqualTo(size);
            Assertions.assertThat((long)statistics.getMax()).isEqualTo((long)i);
            Assertions.assertThat((long)statistics.getMin()).isEqualTo((long)(i + 1 - size));
        }
        statistics = histogram.getStatistics();
        Assertions.assertThat((int)statistics.size()).isEqualTo(size);
        Assertions.assertThat((double)statistics.getQuantile(0.5)).isCloseTo((double)size + (double)(size - 1) / 2.0, Assertions.offset((Double)0.001));
    }
}

