/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.util;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.LogicalScopeProvider;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.SimpleCounter;

public class TestMetricGroup
implements MetricGroup,
LogicalScopeProvider {
    private final String[] scopeComponents;
    private final Map<String, String> variables;
    private final BiFunction<String, Optional<CharacterFilter>, String> metricIdentifierFunction;
    private final BiFunction<CharacterFilter, Optional<Character>, String> logicalScopeFunction;

    public TestMetricGroup(String[] scopeComponents, Map<String, String> variables, BiFunction<String, Optional<CharacterFilter>, String> metricIdentifierFunction, BiFunction<CharacterFilter, Optional<Character>, String> logicalScopeFunction) {
        this.scopeComponents = scopeComponents;
        this.variables = variables;
        this.metricIdentifierFunction = metricIdentifierFunction;
        this.logicalScopeFunction = logicalScopeFunction;
    }

    public static TestMetricGroupBuilder newBuilder() {
        return new TestMetricGroupBuilder();
    }

    public Counter counter(String name) {
        return new SimpleCounter();
    }

    public <C extends Counter> C counter(String name, C counter) {
        return counter;
    }

    public <T, G extends Gauge<T>> G gauge(String name, G gauge) {
        return gauge;
    }

    public <H extends Histogram> H histogram(String name, H histogram) {
        return histogram;
    }

    public <M extends Meter> M meter(String name, M meter) {
        return meter;
    }

    public MetricGroup addGroup(String name) {
        return this;
    }

    public MetricGroup addGroup(String key, String value) {
        return this;
    }

    public String[] getScopeComponents() {
        return this.scopeComponents;
    }

    public Map<String, String> getAllVariables() {
        return this.variables;
    }

    public String getMetricIdentifier(String metricName) {
        return this.metricIdentifierFunction.apply(metricName, Optional.empty());
    }

    public String getMetricIdentifier(String metricName, CharacterFilter filter) {
        return this.metricIdentifierFunction.apply(metricName, Optional.of(filter));
    }

    public String getLogicalScope(CharacterFilter filter) {
        return this.logicalScopeFunction.apply(filter, Optional.empty());
    }

    public String getLogicalScope(CharacterFilter filter, char delimiter) {
        return this.logicalScopeFunction.apply(filter, Optional.of(Character.valueOf(delimiter)));
    }

    public MetricGroup getWrappedMetricGroup() {
        return this;
    }

    public static final class TestMetricGroupBuilder {
        private String[] scopeComponents = new String[0];
        private Map<String, String> variables = Collections.emptyMap();
        private BiFunction<String, Optional<CharacterFilter>, String> metricIdentifierFunction = (name, filter) -> filter.map(f -> f.filterCharacters(name)).orElse((String)name);
        private BiFunction<CharacterFilter, Optional<Character>, String> logicalScopeFunction = (characterFilter, character) -> "logicalScope";

        public TestMetricGroupBuilder setScopeComponents(String[] scopeComponents) {
            this.scopeComponents = scopeComponents;
            return this;
        }

        public TestMetricGroupBuilder setVariables(Map<String, String> variables) {
            this.variables = variables;
            return this;
        }

        public TestMetricGroupBuilder setMetricIdentifierFunction(BiFunction<String, Optional<CharacterFilter>, String> metricIdentifierFunction) {
            this.metricIdentifierFunction = metricIdentifierFunction;
            return this;
        }

        public TestMetricGroupBuilder setLogicalScopeFunction(BiFunction<CharacterFilter, Optional<Character>, String> logicalScopeFunction) {
            this.logicalScopeFunction = logicalScopeFunction;
            return this;
        }

        public TestMetricGroup build() {
            return new TestMetricGroup(this.scopeComponents, this.variables, this.metricIdentifierFunction, this.logicalScopeFunction);
        }
    }
}

