/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics;

import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.HistogramStatistics;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;

public class AbstractHistogramTest
extends TestLogger {
    protected void testHistogram(int size, Histogram histogram) {
        HistogramStatistics statistics;
        int i;
        for (i = 0; i < size; ++i) {
            histogram.update((long)i);
            statistics = histogram.getStatistics();
            Assert.assertEquals((long)(i + 1), (long)histogram.getCount());
            Assert.assertEquals((long)histogram.getCount(), (long)statistics.size());
            Assert.assertEquals((long)i, (long)statistics.getMax());
            Assert.assertEquals((long)0L, (long)statistics.getMin());
        }
        statistics = histogram.getStatistics();
        Assert.assertEquals((long)size, (long)statistics.size());
        Assert.assertEquals((double)((double)(size - 1) / 2.0), (double)statistics.getQuantile(0.5), (double)0.001);
        for (i = size; i < 2 * size; ++i) {
            histogram.update((long)i);
            statistics = histogram.getStatistics();
            Assert.assertEquals((long)(i + 1), (long)histogram.getCount());
            Assert.assertEquals((long)size, (long)statistics.size());
            Assert.assertEquals((long)i, (long)statistics.getMax());
            Assert.assertEquals((long)(i + 1 - size), (long)statistics.getMin());
        }
        statistics = histogram.getStatistics();
        Assert.assertEquals((long)size, (long)statistics.size());
        Assert.assertEquals((double)((double)size + (double)(size - 1) / 2.0), (double)statistics.getQuantile(0.5), (double)0.001);
    }
}

