/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.languagebinding.api.java.common.streaming;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.languagebinding.api.java.common.PlanBinder;
import org.apache.flink.util.Collector;

public class Receiver
implements Serializable {
    private static final long serialVersionUID = -2474088929850009968L;
    private final AbstractRichFunction function;
    private File inputFile;
    private RandomAccessFile inputRAF;
    private FileChannel inputChannel;
    private MappedByteBuffer fileBuffer;
    private Deserializer<?> deserializer = null;

    public Receiver(AbstractRichFunction function) {
        this.function = function;
    }

    public void open(String path) throws IOException {
        this.setupMappedFile(path);
    }

    private void setupMappedFile(String inputFilePath) throws FileNotFoundException, IOException {
        File x = new File(PlanBinder.FLINK_TMP_DATA_DIR);
        x.mkdirs();
        this.inputFile = new File(inputFilePath);
        if (this.inputFile.exists()) {
            this.inputFile.delete();
        }
        this.inputFile.createNewFile();
        this.inputRAF = new RandomAccessFile(inputFilePath, "rw");
        this.inputRAF.setLength(0x4000000L);
        this.inputRAF.seek(0x3FFFFFFL);
        this.inputRAF.writeByte(0);
        this.inputRAF.seek(0L);
        this.inputChannel = this.inputRAF.getChannel();
        this.fileBuffer = this.inputChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 0x4000000L);
    }

    public void close() throws IOException {
        this.closeMappedFile();
    }

    private void closeMappedFile() throws IOException {
        this.inputChannel.close();
        this.inputRAF.close();
    }

    private void loadBuffer() throws IOException {
        for (int count = 0; this.fileBuffer.get(0) == 0 && count < 10; ++count) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.fileBuffer.load();
        }
        if (this.fileBuffer.get(0) == 0) {
            throw new RuntimeException("External process not responding.");
        }
        this.fileBuffer.position(1);
    }

    public Object getRecord() throws IOException {
        return this.getRecord(false);
    }

    public Object getRecord(boolean normalized) throws IOException {
        if (this.fileBuffer.position() == 0) {
            this.loadBuffer();
        }
        return this.receiveField(normalized);
    }

    private Object receiveField(boolean normalized) throws IOException {
        byte type = this.fileBuffer.get();
        switch (type) {
            case 11: {
                int tupleSize = this.fileBuffer.get();
                Tuple tuple = Receiver.createTuple(tupleSize);
                for (int x = 0; x < tupleSize; ++x) {
                    tuple.setField(this.receiveField(normalized), x);
                }
                return tuple;
            }
            case 10: {
                return this.fileBuffer.get() == 1;
            }
            case 9: {
                return this.fileBuffer.get();
            }
            case 8: {
                if (normalized) {
                    return (int)this.fileBuffer.getShort();
                }
                return this.fileBuffer.getShort();
            }
            case 7: {
                return this.fileBuffer.getInt();
            }
            case 6: {
                if (normalized) {
                    return new Long(this.fileBuffer.getLong()).intValue();
                }
                return this.fileBuffer.getLong();
            }
            case 5: {
                if (normalized) {
                    return (double)this.fileBuffer.getFloat();
                }
                return Float.valueOf(this.fileBuffer.getFloat());
            }
            case 4: {
                return this.fileBuffer.getDouble();
            }
            case 2: {
                int stringSize = this.fileBuffer.getInt();
                byte[] buffer = new byte[stringSize];
                this.fileBuffer.get(buffer);
                return new String(buffer);
            }
            case 1: {
                int bytessize = this.fileBuffer.getInt();
                byte[] bytebuffer = new byte[bytessize];
                this.fileBuffer.get(bytebuffer);
                return bytebuffer;
            }
            case 0: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown TypeID encountered: " + type);
    }

    public void collectBuffer(Collector c, int bufferSize) throws IOException {
        this.fileBuffer.position(0);
        if (this.deserializer == null) {
            byte type = this.fileBuffer.get();
            this.deserializer = this.getDeserializer(type);
        }
        while (this.fileBuffer.position() < bufferSize) {
            c.collect(this.deserializer.deserialize());
        }
    }

    private Deserializer<?> getDeserializer(byte type) {
        switch (type) {
            case 11: {
                return new TupleDeserializer();
            }
            case 10: {
                return new BooleanDeserializer();
            }
            case 9: {
                return new ByteDeserializer();
            }
            case 1: {
                return new BytesDeserializer();
            }
            case 8: {
                return new ShortDeserializer();
            }
            case 7: {
                return new IntDeserializer();
            }
            case 6: {
                return new LongDeserializer();
            }
            case 2: {
                return new StringDeserializer();
            }
            case 5: {
                return new FloatDeserializer();
            }
            case 4: {
                return new DoubleDeserializer();
            }
            case 0: {
                return new NullDeserializer();
            }
        }
        throw new IllegalArgumentException("Unknown TypeID encountered: " + type);
    }

    public static Tuple createTuple(int size) {
        try {
            return (Tuple)Tuple.getTupleClass((int)size).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private class TupleDeserializer
    implements Deserializer<Tuple> {
        Deserializer<?>[] deserializer = null;
        Tuple reuse;

        public TupleDeserializer() {
            int size = Receiver.this.fileBuffer.getInt();
            this.reuse = Receiver.createTuple(size);
            this.deserializer = new Deserializer[size];
            for (int x = 0; x < this.deserializer.length; ++x) {
                this.deserializer[x] = Receiver.this.getDeserializer(Receiver.this.fileBuffer.get());
            }
        }

        @Override
        public Tuple deserialize() {
            for (int x = 0; x < this.deserializer.length; ++x) {
                this.reuse.setField(this.deserializer[x].deserialize(), x);
            }
            return this.reuse;
        }
    }

    private class BytesDeserializer
    implements Deserializer<byte[]> {
        private BytesDeserializer() {
        }

        @Override
        public byte[] deserialize() {
            int length = Receiver.this.fileBuffer.getInt();
            byte[] result = new byte[length];
            Receiver.this.fileBuffer.get(result);
            return result;
        }
    }

    private class NullDeserializer
    implements Deserializer<Object> {
        private NullDeserializer() {
        }

        @Override
        public Object deserialize() {
            return null;
        }
    }

    private class StringDeserializer
    implements Deserializer<String> {
        private int size;

        private StringDeserializer() {
        }

        @Override
        public String deserialize() {
            this.size = Receiver.this.fileBuffer.getInt();
            byte[] buffer = new byte[this.size];
            Receiver.this.fileBuffer.get(buffer);
            return new String(buffer);
        }
    }

    private class DoubleDeserializer
    implements Deserializer<Double> {
        private DoubleDeserializer() {
        }

        @Override
        public Double deserialize() {
            return Receiver.this.fileBuffer.getDouble();
        }
    }

    private class FloatDeserializer
    implements Deserializer<Float> {
        private FloatDeserializer() {
        }

        @Override
        public Float deserialize() {
            return Float.valueOf(Receiver.this.fileBuffer.getFloat());
        }
    }

    private class LongDeserializer
    implements Deserializer<Long> {
        private LongDeserializer() {
        }

        @Override
        public Long deserialize() {
            return Receiver.this.fileBuffer.getLong();
        }
    }

    private class IntDeserializer
    implements Deserializer<Integer> {
        private IntDeserializer() {
        }

        @Override
        public Integer deserialize() {
            return Receiver.this.fileBuffer.getInt();
        }
    }

    private class ShortDeserializer
    implements Deserializer<Short> {
        private ShortDeserializer() {
        }

        @Override
        public Short deserialize() {
            return Receiver.this.fileBuffer.getShort();
        }
    }

    private class ByteDeserializer
    implements Deserializer<Byte> {
        private ByteDeserializer() {
        }

        @Override
        public Byte deserialize() {
            return Receiver.this.fileBuffer.get();
        }
    }

    private class BooleanDeserializer
    implements Deserializer<Boolean> {
        private BooleanDeserializer() {
        }

        @Override
        public Boolean deserialize() {
            return Receiver.this.fileBuffer.get() == 1;
        }
    }

    private static interface Deserializer<T> {
        public T deserialize();
    }
}

