/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.languagebinding.api.java.common;

import java.io.IOException;
import java.util.HashMap;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.CsvInputFormat;
import org.apache.flink.api.java.io.PrintingOutputFormat;
import org.apache.flink.api.java.operators.AggregateOperator;
import org.apache.flink.api.java.operators.CrossOperator;
import org.apache.flink.api.java.operators.Grouping;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.SortedGrouping;
import org.apache.flink.api.java.operators.UdfOperator;
import org.apache.flink.api.java.operators.UnsortedGrouping;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.languagebinding.api.java.common.OperationInfo;
import org.apache.flink.languagebinding.api.java.common.streaming.Receiver;

public abstract class PlanBinder<INFO extends OperationInfo> {
    public static final String PLANBINDER_CONFIG_BCVAR_COUNT = "PLANBINDER_BCVAR_COUNT";
    public static final String PLANBINDER_CONFIG_BCVAR_NAME_PREFIX = "PLANBINDER_BCVAR_";
    protected static String FLINK_HDFS_PATH = "hdfs:/tmp";
    public static final String FLINK_TMP_DATA_DIR = System.getProperty("java.io.tmpdir") + "/flink_data";
    public static boolean DEBUG = false;
    protected HashMap<Integer, Object> sets = new HashMap();
    public static ExecutionEnvironment env;
    protected Receiver receiver;
    public static final int MAPPED_FILE_SIZE = 0x4000000;

    protected void receivePlan() throws IOException {
        this.receiveParameters();
        this.receiveOperations();
    }

    private void receiveParameters() throws IOException {
        Integer parameterCount = (Integer)this.receiver.getRecord(true);
        block6: for (int x = 0; x < parameterCount; ++x) {
            Tuple value = (Tuple)this.receiver.getRecord(true);
            switch (Parameters.valueOf(((String)value.getField(0)).toUpperCase())) {
                case DOP: {
                    Integer dop = (Integer)value.getField(1);
                    env.setParallelism(dop.intValue());
                    continue block6;
                }
                case MODE: {
                    FLINK_HDFS_PATH = (Boolean)value.getField(1) != false ? "file:/tmp/flink" : "hdfs:/tmp/flink";
                    continue block6;
                }
                case RETRY: {
                    int retry = (Integer)value.getField(1);
                    env.setNumberOfExecutionRetries(retry);
                    continue block6;
                }
                case DEBUG: {
                    DEBUG = (Boolean)value.getField(1);
                }
            }
        }
        if (env.getParallelism() < 0) {
            env.setParallelism(1);
        }
    }

    protected void receiveOperations() throws IOException {
        Integer operationCount = (Integer)this.receiver.getRecord(true);
        block38: for (int x = 0; x < operationCount; ++x) {
            String identifier = (String)this.receiver.getRecord();
            Operation op = null;
            AbstractOperation aop = null;
            try {
                op = Operation.valueOf(identifier.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                try {
                    aop = AbstractOperation.valueOf(identifier.toUpperCase());
                }
                catch (IllegalArgumentException iae2) {
                    throw new IllegalArgumentException("Invalid operation specified: " + identifier);
                }
            }
            if (op != null) {
                switch (op) {
                    case SOURCE_CSV: {
                        this.createCsvSource(this.createOperationInfo(op));
                        break;
                    }
                    case SOURCE_TEXT: {
                        this.createTextSource(this.createOperationInfo(op));
                        break;
                    }
                    case SOURCE_VALUE: {
                        this.createValueSource(this.createOperationInfo(op));
                        break;
                    }
                    case SOURCE_SEQ: {
                        this.createSequenceSource(this.createOperationInfo(op));
                        break;
                    }
                    case SINK_CSV: {
                        this.createCsvSink(this.createOperationInfo(op));
                        break;
                    }
                    case SINK_TEXT: {
                        this.createTextSink(this.createOperationInfo(op));
                        break;
                    }
                    case SINK_PRINT: {
                        this.createPrintSink(this.createOperationInfo(op));
                        break;
                    }
                    case BROADCAST: {
                        this.createBroadcastVariable(this.createOperationInfo(op));
                        break;
                    }
                    case AGGREGATE: {
                        this.createAggregationOperation(this.createOperationInfo(op));
                        break;
                    }
                    case DISTINCT: {
                        this.createDistinctOperation(this.createOperationInfo(op));
                        break;
                    }
                    case FIRST: {
                        this.createFirstOperation(this.createOperationInfo(op));
                        break;
                    }
                    case PARTITION_HASH: {
                        this.createHashPartitionOperation(this.createOperationInfo(op));
                        break;
                    }
                    case PROJECTION: {
                        this.createProjectOperation(this.createOperationInfo(op));
                        break;
                    }
                    case REBALANCE: {
                        this.createRebalanceOperation(this.createOperationInfo(op));
                        break;
                    }
                    case GROUPBY: {
                        this.createGroupOperation(this.createOperationInfo(op));
                        break;
                    }
                    case SORT: {
                        this.createSortOperation(this.createOperationInfo(op));
                        break;
                    }
                    case UNION: {
                        this.createUnionOperation(this.createOperationInfo(op));
                    }
                }
            }
            if (aop == null) continue;
            switch (aop) {
                case COGROUP: {
                    this.createCoGroupOperation(this.createOperationInfo(aop));
                    continue block38;
                }
                case CROSS: {
                    this.createCrossOperation(OperationInfo.DatasizeHint.NONE, this.createOperationInfo(aop));
                    continue block38;
                }
                case CROSS_H: {
                    this.createCrossOperation(OperationInfo.DatasizeHint.HUGE, this.createOperationInfo(aop));
                    continue block38;
                }
                case CROSS_T: {
                    this.createCrossOperation(OperationInfo.DatasizeHint.TINY, this.createOperationInfo(aop));
                    continue block38;
                }
                case FILTER: {
                    this.createFilterOperation(this.createOperationInfo(aop));
                    continue block38;
                }
                case FLATMAP: {
                    this.createFlatMapOperation(this.createOperationInfo(aop));
                    continue block38;
                }
                case GROUPREDUCE: {
                    this.createGroupReduceOperation(this.createOperationInfo(aop));
                    continue block38;
                }
                case JOIN: {
                    this.createJoinOperation(OperationInfo.DatasizeHint.NONE, this.createOperationInfo(aop));
                    continue block38;
                }
                case JOIN_H: {
                    this.createJoinOperation(OperationInfo.DatasizeHint.HUGE, this.createOperationInfo(aop));
                    continue block38;
                }
                case JOIN_T: {
                    this.createJoinOperation(OperationInfo.DatasizeHint.TINY, this.createOperationInfo(aop));
                    continue block38;
                }
                case MAP: {
                    this.createMapOperation(this.createOperationInfo(aop));
                    continue block38;
                }
                case MAPPARTITION: {
                    this.createMapPartitionOperation(this.createOperationInfo(aop));
                    continue block38;
                }
                case REDUCE: {
                    this.createReduceOperation(this.createOperationInfo(aop));
                }
            }
        }
    }

    protected OperationInfo createOperationInfo(Operation operationIdentifier) throws IOException {
        return new OperationInfo(this.receiver, operationIdentifier);
    }

    protected abstract INFO createOperationInfo(AbstractOperation var1) throws IOException;

    private void createCsvSource(OperationInfo info) throws IOException {
        if (!(info.types instanceof CompositeType)) {
            throw new RuntimeException("The output type of a csv source has to be a tuple or a pojo type. The derived type is " + info);
        }
        this.sets.put(info.setID, env.createInput((InputFormat)new CsvInputFormat(new Path(info.path), info.lineDelimiter, info.fieldDelimiter, (CompositeType)info.types), info.types).name("CsvSource"));
    }

    private void createTextSource(OperationInfo info) throws IOException {
        this.sets.put(info.setID, env.readTextFile(info.path).name("TextSource"));
    }

    private void createValueSource(OperationInfo info) throws IOException {
        this.sets.put(info.setID, env.fromElements(info.values).name("ValueSource"));
    }

    private void createSequenceSource(OperationInfo info) throws IOException {
        this.sets.put(info.setID, env.generateSequence(info.from, info.to).name("SequenceSource"));
    }

    private void createCsvSink(OperationInfo info) throws IOException {
        DataSet parent = (DataSet)this.sets.get(info.parentID);
        parent.writeAsCsv(info.path, info.lineDelimiter, info.fieldDelimiter, info.writeMode).name("CsvSink");
    }

    private void createTextSink(OperationInfo info) throws IOException {
        DataSet parent = (DataSet)this.sets.get(info.parentID);
        parent.writeAsText(info.path, info.writeMode).name("TextSink");
    }

    private void createPrintSink(OperationInfo info) throws IOException {
        DataSet parent = (DataSet)this.sets.get(info.parentID);
        parent.output((OutputFormat)new PrintingOutputFormat(info.toError));
    }

    private void createBroadcastVariable(OperationInfo info) throws IOException {
        UdfOperator op1 = (UdfOperator)this.sets.get(info.parentID);
        DataSet op2 = (DataSet)this.sets.get(info.otherID);
        op1.withBroadcastSet(op2, info.name);
        Configuration c = op1.getParameters();
        if (c == null) {
            c = new Configuration();
        }
        int count = c.getInteger(PLANBINDER_CONFIG_BCVAR_COUNT, 0);
        c.setInteger(PLANBINDER_CONFIG_BCVAR_COUNT, count + 1);
        c.setString(PLANBINDER_CONFIG_BCVAR_NAME_PREFIX + count, info.name);
        op1.withParameters(c);
    }

    private void createAggregationOperation(OperationInfo info) throws IOException {
        DataSet op = (DataSet)this.sets.get(info.parentID);
        AggregateOperator ao = op.aggregate(info.aggregates[0].agg, info.aggregates[0].field);
        for (int x = 1; x < info.count; ++x) {
            ao = ao.and(info.aggregates[x].agg, info.aggregates[x].field);
        }
        this.sets.put(info.setID, ao.name("Aggregation"));
    }

    private void createDistinctOperation(OperationInfo info) throws IOException {
        DataSet op = (DataSet)this.sets.get(info.parentID);
        this.sets.put(info.setID, info.keys.length == 0 ? op.distinct() : op.distinct(info.keys).name("Distinct"));
    }

    private void createFirstOperation(OperationInfo info) throws IOException {
        DataSet op = (DataSet)this.sets.get(info.parentID);
        this.sets.put(info.setID, op.first(info.count).name("First"));
    }

    private void createGroupOperation(OperationInfo info) throws IOException {
        DataSet op1 = (DataSet)this.sets.get(info.parentID);
        this.sets.put(info.setID, op1.groupBy(info.keys));
    }

    private void createHashPartitionOperation(OperationInfo info) throws IOException {
        DataSet op1 = (DataSet)this.sets.get(info.parentID);
        this.sets.put(info.setID, op1.partitionByHash(info.keys));
    }

    private void createProjectOperation(OperationInfo info) throws IOException {
        DataSet op1 = (DataSet)this.sets.get(info.parentID);
        this.sets.put(info.setID, op1.project(info.fields).name("Projection"));
    }

    private void createRebalanceOperation(OperationInfo info) throws IOException {
        DataSet op = (DataSet)this.sets.get(info.parentID);
        this.sets.put(info.setID, op.rebalance().name("Rebalance"));
    }

    private void createSortOperation(OperationInfo info) throws IOException {
        Grouping op1 = (Grouping)this.sets.get(info.parentID);
        if (op1 instanceof UnsortedGrouping) {
            this.sets.put(info.setID, ((UnsortedGrouping)op1).sortGroup(info.field, info.order));
            return;
        }
        if (op1 instanceof SortedGrouping) {
            this.sets.put(info.setID, ((SortedGrouping)op1).sortGroup(info.field, info.order));
        }
    }

    private void createUnionOperation(OperationInfo info) throws IOException {
        DataSet op1 = (DataSet)this.sets.get(info.parentID);
        DataSet op2 = (DataSet)this.sets.get(info.otherID);
        this.sets.put(info.setID, op1.union(op2).name("Union"));
    }

    private void createCoGroupOperation(INFO info) {
        DataSet op1 = (DataSet)this.sets.get(((OperationInfo)info).parentID);
        DataSet op2 = (DataSet)this.sets.get(((OperationInfo)info).otherID);
        this.sets.put(((OperationInfo)info).setID, this.applyCoGroupOperation(op1, op2, ((OperationInfo)info).keys1, ((OperationInfo)info).keys2, info));
    }

    private void createCrossOperation(OperationInfo.DatasizeHint mode, INFO info) {
        DataSet op1 = (DataSet)this.sets.get(((OperationInfo)info).parentID);
        DataSet op2 = (DataSet)this.sets.get(((OperationInfo)info).otherID);
        if (((OperationInfo)info).types != null && (((OperationInfo)info).projections == null || ((OperationInfo)info).projections.length == 0)) {
            this.sets.put(((OperationInfo)info).setID, this.applyCrossOperation(op1, op2, mode, info));
        } else {
            CrossOperator.DefaultCross defaultResult;
            switch (mode) {
                case NONE: {
                    defaultResult = op1.cross(op2);
                    break;
                }
                case HUGE: {
                    defaultResult = op1.crossWithHuge(op2);
                    break;
                }
                case TINY: {
                    defaultResult = op1.crossWithTiny(op2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid Cross mode specified: " + (Object)((Object)mode));
                }
            }
            if (((OperationInfo)info).projections.length == 0) {
                this.sets.put(((OperationInfo)info).setID, defaultResult.name("DefaultCross"));
            } else {
                CrossOperator.ProjectCross project = null;
                block9: for (OperationInfo.ProjectionEntry pe : ((OperationInfo)info).projections) {
                    switch (pe.side) {
                        case FIRST: {
                            project = project == null ? defaultResult.projectFirst(pe.keys) : project.projectFirst(pe.keys);
                            continue block9;
                        }
                        case SECOND: {
                            project = project == null ? defaultResult.projectSecond(pe.keys) : project.projectSecond(pe.keys);
                        }
                    }
                }
                this.sets.put(((OperationInfo)info).setID, project.name("ProjectCross"));
            }
        }
    }

    private void createFilterOperation(INFO info) {
        DataSet op1 = (DataSet)this.sets.get(((OperationInfo)info).parentID);
        this.sets.put(((OperationInfo)info).setID, this.applyFilterOperation(op1, info));
    }

    private void createFlatMapOperation(INFO info) {
        DataSet op1 = (DataSet)this.sets.get(((OperationInfo)info).parentID);
        this.sets.put(((OperationInfo)info).setID, this.applyFlatMapOperation(op1, info));
    }

    private void createGroupReduceOperation(INFO info) {
        Object op1 = this.sets.get(((OperationInfo)info).parentID);
        if (op1 instanceof DataSet) {
            this.sets.put(((OperationInfo)info).setID, this.applyGroupReduceOperation((DataSet)op1, info));
            return;
        }
        if (op1 instanceof UnsortedGrouping) {
            this.sets.put(((OperationInfo)info).setID, this.applyGroupReduceOperation((UnsortedGrouping)op1, info));
            return;
        }
        if (op1 instanceof SortedGrouping) {
            this.sets.put(((OperationInfo)info).setID, this.applyGroupReduceOperation((SortedGrouping)op1, info));
        }
    }

    private void createJoinOperation(OperationInfo.DatasizeHint mode, INFO info) {
        DataSet op1 = (DataSet)this.sets.get(((OperationInfo)info).parentID);
        DataSet op2 = (DataSet)this.sets.get(((OperationInfo)info).otherID);
        if (((OperationInfo)info).types != null && (((OperationInfo)info).projections == null || ((OperationInfo)info).projections.length == 0)) {
            this.sets.put(((OperationInfo)info).setID, this.applyJoinOperation(op1, op2, ((OperationInfo)info).keys1, ((OperationInfo)info).keys2, mode, info));
        } else {
            JoinOperator.DefaultJoin defaultResult = this.createDefaultJoin(op1, op2, ((OperationInfo)info).keys1, ((OperationInfo)info).keys2, mode);
            if (((OperationInfo)info).projections.length == 0) {
                this.sets.put(((OperationInfo)info).setID, defaultResult.name("DefaultJoin"));
            } else {
                JoinOperator.ProjectJoin project = null;
                block4: for (OperationInfo.ProjectionEntry pe : ((OperationInfo)info).projections) {
                    switch (pe.side) {
                        case FIRST: {
                            project = project == null ? defaultResult.projectFirst(pe.keys) : project.projectFirst(pe.keys);
                            continue block4;
                        }
                        case SECOND: {
                            project = project == null ? defaultResult.projectSecond(pe.keys) : project.projectSecond(pe.keys);
                        }
                    }
                }
                this.sets.put(((OperationInfo)info).setID, project.name("ProjectJoin"));
            }
        }
    }

    protected JoinOperator.DefaultJoin createDefaultJoin(DataSet op1, DataSet op2, String[] firstKeys, String[] secondKeys, OperationInfo.DatasizeHint mode) {
        switch (mode) {
            case NONE: {
                return op1.join(op2).where(firstKeys).equalTo(secondKeys);
            }
            case HUGE: {
                return op1.joinWithHuge(op2).where(firstKeys).equalTo(secondKeys);
            }
            case TINY: {
                return op1.joinWithTiny(op2).where(firstKeys).equalTo(secondKeys);
            }
        }
        throw new IllegalArgumentException("Invalid join mode specified.");
    }

    private void createMapOperation(INFO info) {
        DataSet op1 = (DataSet)this.sets.get(((OperationInfo)info).parentID);
        this.sets.put(((OperationInfo)info).setID, this.applyMapOperation(op1, info));
    }

    private void createMapPartitionOperation(INFO info) {
        DataSet op1 = (DataSet)this.sets.get(((OperationInfo)info).parentID);
        this.sets.put(((OperationInfo)info).setID, this.applyMapPartitionOperation(op1, info));
    }

    private void createReduceOperation(INFO info) {
        Object op1 = this.sets.get(((OperationInfo)info).parentID);
        if (op1 instanceof DataSet) {
            this.sets.put(((OperationInfo)info).setID, this.applyReduceOperation((DataSet)op1, info));
            return;
        }
        if (op1 instanceof UnsortedGrouping) {
            this.sets.put(((OperationInfo)info).setID, this.applyReduceOperation((UnsortedGrouping)op1, info));
        }
    }

    protected abstract DataSet applyCoGroupOperation(DataSet var1, DataSet var2, String[] var3, String[] var4, INFO var5);

    protected abstract DataSet applyCrossOperation(DataSet var1, DataSet var2, OperationInfo.DatasizeHint var3, INFO var4);

    protected abstract DataSet applyFilterOperation(DataSet var1, INFO var2);

    protected abstract DataSet applyFlatMapOperation(DataSet var1, INFO var2);

    protected abstract DataSet applyGroupReduceOperation(DataSet var1, INFO var2);

    protected abstract DataSet applyGroupReduceOperation(UnsortedGrouping var1, INFO var2);

    protected abstract DataSet applyGroupReduceOperation(SortedGrouping var1, INFO var2);

    protected abstract DataSet applyJoinOperation(DataSet var1, DataSet var2, String[] var3, String[] var4, OperationInfo.DatasizeHint var5, INFO var6);

    protected abstract DataSet applyMapOperation(DataSet var1, INFO var2);

    protected abstract DataSet applyMapPartitionOperation(DataSet var1, INFO var2);

    protected abstract DataSet applyReduceOperation(DataSet var1, INFO var2);

    protected abstract DataSet applyReduceOperation(UnsortedGrouping var1, INFO var2);

    protected static String[] normalizeKeys(Object keys) {
        if (keys instanceof Tuple) {
            Tuple tupleKeys = (Tuple)keys;
            if (tupleKeys.getArity() == 0) {
                return new String[0];
            }
            if (tupleKeys.getField(0) instanceof Integer) {
                String[] stringKeys = new String[tupleKeys.getArity()];
                for (int x = 0; x < stringKeys.length; ++x) {
                    stringKeys[x] = "f" + (Integer)tupleKeys.getField(x);
                }
                return stringKeys;
            }
            if (tupleKeys.getField(0) instanceof String) {
                return PlanBinder.tupleToStringArray(tupleKeys);
            }
            throw new RuntimeException("Key argument contains field that is neither an int nor a String.");
        }
        if (keys instanceof int[]) {
            int[] intKeys = (int[])keys;
            String[] stringKeys = new String[intKeys.length];
            for (int x = 0; x < stringKeys.length; ++x) {
                stringKeys[x] = "f" + intKeys[x];
            }
            return stringKeys;
        }
        throw new RuntimeException("Key argument is neither an int[] nor a Tuple.");
    }

    protected static int[] toIntArray(Object key) {
        if (key instanceof Tuple) {
            Tuple tuple = (Tuple)key;
            int[] keys = new int[tuple.getArity()];
            for (int y = 0; y < tuple.getArity(); ++y) {
                keys[y] = (Integer)tuple.getField(y);
            }
            return keys;
        }
        if (key instanceof int[]) {
            return (int[])key;
        }
        throw new RuntimeException("Key argument is neither an int[] nor a Tuple.");
    }

    protected static String[] tupleToStringArray(Tuple tuple) {
        String[] keys = new String[tuple.getArity()];
        for (int y = 0; y < tuple.getArity(); ++y) {
            keys[y] = (String)tuple.getField(y);
        }
        return keys;
    }

    protected static enum AbstractOperation {
        COGROUP,
        CROSS,
        CROSS_H,
        CROSS_T,
        FILTER,
        FLATMAP,
        GROUPREDUCE,
        JOIN,
        JOIN_H,
        JOIN_T,
        MAP,
        REDUCE,
        MAPPARTITION;

    }

    protected static enum Operation {
        SOURCE_CSV,
        SOURCE_TEXT,
        SOURCE_VALUE,
        SOURCE_SEQ,
        SINK_CSV,
        SINK_TEXT,
        SINK_PRINT,
        PROJECTION,
        SORT,
        UNION,
        FIRST,
        DISTINCT,
        GROUPBY,
        AGGREGATE,
        REBALANCE,
        PARTITION_HASH,
        BROADCAST;

    }

    private static enum Parameters {
        DOP,
        MODE,
        RETRY,
        DEBUG;

    }
}

