/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.languagebinding.api.java.common;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.languagebinding.api.java.common.PlanBinder;
import org.apache.flink.languagebinding.api.java.common.streaming.Receiver;

public class OperationInfo {
    public int parentID;
    public int otherID;
    public int setID;
    public String[] keys;
    public String[] keys1;
    public String[] keys2;
    public TypeInformation<?> types;
    public AggregationEntry[] aggregates;
    public ProjectionEntry[] projections;
    public Object[] values;
    public int count;
    public int field;
    public int[] fields;
    public Order order;
    public String path;
    public String fieldDelimiter;
    public String lineDelimiter;
    public long from;
    public long to;
    public FileSystem.WriteMode writeMode;
    public boolean toError;
    public String name;

    public OperationInfo() {
    }

    public OperationInfo(Receiver receiver, PlanBinder.Operation identifier) throws IOException {
        switch (identifier) {
            case SOURCE_CSV: {
                this.setID = (Integer)receiver.getRecord(true);
                this.path = (String)receiver.getRecord();
                this.fieldDelimiter = (String)receiver.getRecord();
                this.lineDelimiter = (String)receiver.getRecord();
                Tuple tmpType = (Tuple)receiver.getRecord();
                this.types = tmpType == null ? null : TypeExtractor.getForObject((Object)tmpType);
                return;
            }
            case SOURCE_TEXT: {
                this.setID = (Integer)receiver.getRecord(true);
                this.path = (String)receiver.getRecord();
                return;
            }
            case SOURCE_VALUE: {
                this.setID = (Integer)receiver.getRecord(true);
                int valueCount = (Integer)receiver.getRecord(true);
                this.values = new Object[valueCount];
                for (int x = 0; x < valueCount; ++x) {
                    this.values[x] = receiver.getRecord();
                }
                return;
            }
            case SOURCE_SEQ: {
                this.setID = (Integer)receiver.getRecord(true);
                this.from = (Long)receiver.getRecord();
                this.to = (Long)receiver.getRecord();
                return;
            }
            case SINK_CSV: {
                this.parentID = (Integer)receiver.getRecord(true);
                this.path = (String)receiver.getRecord();
                this.fieldDelimiter = (String)receiver.getRecord();
                this.lineDelimiter = (String)receiver.getRecord();
                this.writeMode = (Integer)receiver.getRecord(true) == 1 ? FileSystem.WriteMode.OVERWRITE : FileSystem.WriteMode.NO_OVERWRITE;
                return;
            }
            case SINK_TEXT: {
                this.parentID = (Integer)receiver.getRecord(true);
                this.path = (String)receiver.getRecord();
                this.writeMode = (Integer)receiver.getRecord(true) == 1 ? FileSystem.WriteMode.OVERWRITE : FileSystem.WriteMode.NO_OVERWRITE;
                return;
            }
            case SINK_PRINT: {
                this.parentID = (Integer)receiver.getRecord(true);
                this.toError = (Boolean)receiver.getRecord();
                return;
            }
            case BROADCAST: {
                this.parentID = (Integer)receiver.getRecord(true);
                this.otherID = (Integer)receiver.getRecord(true);
                this.name = (String)receiver.getRecord();
                return;
            }
        }
        this.setID = (Integer)receiver.getRecord(true);
        this.parentID = (Integer)receiver.getRecord(true);
        switch (identifier) {
            case AGGREGATE: {
                this.count = (Integer)receiver.getRecord(true);
                this.aggregates = new AggregationEntry[this.count];
                for (int x = 0; x < this.count; ++x) {
                    int encodedAgg = (Integer)receiver.getRecord(true);
                    int field = (Integer)receiver.getRecord(true);
                    this.aggregates[x] = new AggregationEntry(encodedAgg, field);
                }
                return;
            }
            case FIRST: {
                this.count = (Integer)receiver.getRecord(true);
                return;
            }
            case DISTINCT: 
            case GROUPBY: 
            case PARTITION_HASH: {
                this.keys = PlanBinder.normalizeKeys(receiver.getRecord(true));
                return;
            }
            case PROJECTION: {
                this.fields = PlanBinder.toIntArray(receiver.getRecord(true));
                return;
            }
            case REBALANCE: {
                return;
            }
            case SORT: {
                this.field = (Integer)receiver.getRecord(true);
                int encodedOrder = (Integer)receiver.getRecord(true);
                switch (encodedOrder) {
                    case 0: {
                        this.order = Order.NONE;
                        break;
                    }
                    case 1: {
                        this.order = Order.ASCENDING;
                        break;
                    }
                    case 2: {
                        this.order = Order.DESCENDING;
                        break;
                    }
                    case 3: {
                        this.order = Order.ANY;
                        break;
                    }
                    default: {
                        this.order = Order.NONE;
                    }
                }
                return;
            }
            case UNION: {
                this.otherID = (Integer)receiver.getRecord(true);
                return;
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SetID: ").append(this.setID).append("\n");
        sb.append("ParentID: ").append(this.parentID).append("\n");
        sb.append("OtherID: ").append(this.otherID).append("\n");
        sb.append("Name: ").append(this.name).append("\n");
        sb.append("Types: ").append(this.types).append("\n");
        sb.append("Keys1: ").append(Arrays.toString(this.keys1)).append("\n");
        sb.append("Keys2: ").append(Arrays.toString(this.keys2)).append("\n");
        sb.append("Keys: ").append(Arrays.toString(this.keys)).append("\n");
        sb.append("Aggregates: ").append(Arrays.toString(this.aggregates)).append("\n");
        sb.append("Projections: ").append(Arrays.toString(this.projections)).append("\n");
        sb.append("Count: ").append(this.count).append("\n");
        sb.append("Field: ").append(this.field).append("\n");
        sb.append("Order: ").append(this.order.toString()).append("\n");
        sb.append("Path: ").append(this.path).append("\n");
        sb.append("FieldDelimiter: ").append(this.fieldDelimiter).append("\n");
        sb.append("LineDelimiter: ").append(this.lineDelimiter).append("\n");
        sb.append("From: ").append(this.from).append("\n");
        sb.append("To: ").append(this.to).append("\n");
        sb.append("WriteMode: ").append(this.writeMode).append("\n");
        sb.append("toError: ").append(this.toError).append("\n");
        return sb.toString();
    }

    public static enum DatasizeHint {
        NONE,
        TINY,
        HUGE;

    }

    public static enum ProjectionSide {
        FIRST,
        SECOND;

    }

    public static class ProjectionEntry {
        public ProjectionSide side;
        public int[] keys;

        public ProjectionEntry(ProjectionSide side, int[] keys) {
            this.side = side;
            this.keys = keys;
        }

        public String toString() {
            return (Object)((Object)this.side) + " - " + Arrays.toString(this.keys);
        }
    }

    public static class AggregationEntry {
        public Aggregations agg;
        public int field;

        public AggregationEntry(int encodedAgg, int field) {
            switch (encodedAgg) {
                case 0: {
                    this.agg = Aggregations.MAX;
                    break;
                }
                case 1: {
                    this.agg = Aggregations.MIN;
                    break;
                }
                case 2: {
                    this.agg = Aggregations.SUM;
                }
            }
            this.field = field;
        }

        public String toString() {
            return this.agg.toString() + " - " + this.field;
        }
    }
}

