/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.kubeclient.Fabric8FlinkKubeClient;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClient;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkKubeClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkKubeClientFactory.class);
    private static final FlinkKubeClientFactory INSTANCE = new FlinkKubeClientFactory();

    public static FlinkKubeClientFactory getInstance() {
        return INSTANCE;
    }

    public FlinkKubeClient fromConfiguration(Configuration flinkConfig, String useCase) {
        Config config;
        String kubeConfigFile;
        String kubeContext = flinkConfig.getString(KubernetesConfigOptions.CONTEXT);
        if (kubeContext != null) {
            LOG.info("Configuring kubernetes client to use context {}.", (Object)kubeContext);
        }
        if ((kubeConfigFile = flinkConfig.getString(KubernetesConfigOptions.KUBE_CONFIG_FILE)) != null) {
            LOG.debug("Trying to load kubernetes config from file: {}.", (Object)kubeConfigFile);
            try {
                config = Config.fromKubeconfig(kubeContext, FileUtils.readFileUtf8((File)new File(kubeConfigFile)), null);
            }
            catch (IOException e) {
                throw new KubernetesClientException("Load kubernetes config failed.", e);
            }
        } else {
            LOG.debug("Trying to load default kubernetes config.");
            config = Config.autoConfigure(kubeContext);
        }
        String namespace = flinkConfig.getString(KubernetesConfigOptions.NAMESPACE);
        LOG.debug("Setting namespace of Kubernetes client to {}", (Object)namespace);
        config.setNamespace(namespace);
        FlinkKubeClientFactory.trySetMaxConcurrentRequest(config);
        DefaultKubernetesClient client = new DefaultKubernetesClient(config);
        int poolSize = (Integer)flinkConfig.get(KubernetesConfigOptions.KUBERNETES_CLIENT_IO_EXECUTOR_POOL_SIZE);
        return new Fabric8FlinkKubeClient(flinkConfig, client, FlinkKubeClientFactory.createThreadPoolForAsyncIO(poolSize, useCase));
    }

    @VisibleForTesting
    static void trySetMaxConcurrentRequest(Config config) {
        String configuredMaxConcurrentRequests = Utils.getSystemPropertyOrEnvVar("kubernetes.max.concurrent.requests", String.valueOf(Config.DEFAULT_MAX_CONCURRENT_REQUESTS));
        if (configuredMaxConcurrentRequests != null) {
            LOG.debug("Setting max concurrent requests of Kubernetes client to {}", (Object)configuredMaxConcurrentRequests);
            config.setMaxConcurrentRequests(Integer.parseInt(configuredMaxConcurrentRequests));
        }
    }

    private static ExecutorService createThreadPoolForAsyncIO(int poolSize, String useCase) {
        return Executors.newFixedThreadPool(poolSize, (ThreadFactory)new ExecutorThreadFactory("flink-kubeclient-io-for-" + useCase));
    }
}

