/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsFluentImpl;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetrics;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PodMetricsFluentImpl<A extends PodMetricsFluent<A>>
extends BaseFluent<A>
implements PodMetricsFluent<A> {
    private String apiVersion;
    private List<ContainerMetricsBuilder> containers = new ArrayList<ContainerMetricsBuilder>();
    private String kind;
    private ObjectMetaBuilder metadata;
    private String timestamp;
    private Duration window;

    public PodMetricsFluentImpl() {
    }

    public PodMetricsFluentImpl(PodMetrics instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withContainers(instance.getContainers());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withTimestamp(instance.getTimestamp());
        this.withWindow(instance.getWindow());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToContainers(int index, ContainerMetrics item) {
        if (this.containers == null) {
            this.containers = new ArrayList<ContainerMetricsBuilder>();
        }
        ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);
        this._visitables.get("containers").add(index >= 0 ? index : this._visitables.get("containers").size(), builder);
        this.containers.add(index >= 0 ? index : this.containers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToContainers(int index, ContainerMetrics item) {
        if (this.containers == null) {
            this.containers = new ArrayList<ContainerMetricsBuilder>();
        }
        ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);
        if (index < 0 || index >= this._visitables.get("containers").size()) {
            this._visitables.get("containers").add(builder);
        } else {
            this._visitables.get("containers").set(index, builder);
        }
        if (index < 0 || index >= this.containers.size()) {
            this.containers.add(builder);
        } else {
            this.containers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToContainers(ContainerMetrics ... items) {
        if (this.containers == null) {
            this.containers = new ArrayList<ContainerMetricsBuilder>();
        }
        for (ContainerMetrics item : items) {
            ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainers(Collection<ContainerMetrics> items) {
        if (this.containers == null) {
            this.containers = new ArrayList<ContainerMetricsBuilder>();
        }
        for (ContainerMetrics item : items) {
            ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainers(ContainerMetrics ... items) {
        for (ContainerMetrics item : items) {
            ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);
            this._visitables.get("containers").remove(builder);
            if (this.containers == null) continue;
            this.containers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainers(Collection<ContainerMetrics> items) {
        for (ContainerMetrics item : items) {
            ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);
            this._visitables.get("containers").remove(builder);
            if (this.containers == null) continue;
            this.containers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromContainers(Predicate<ContainerMetricsBuilder> predicate) {
        if (this.containers == null) {
            return (A)this;
        }
        Iterator<ContainerMetricsBuilder> each = this.containers.iterator();
        Object visitables = this._visitables.get("containers");
        while (each.hasNext()) {
            ContainerMetricsBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ContainerMetrics> getContainers() {
        return PodMetricsFluentImpl.build(this.containers);
    }

    @Override
    public List<ContainerMetrics> buildContainers() {
        return PodMetricsFluentImpl.build(this.containers);
    }

    @Override
    public ContainerMetrics buildContainer(int index) {
        return this.containers.get(index).build();
    }

    @Override
    public ContainerMetrics buildFirstContainer() {
        return this.containers.get(0).build();
    }

    @Override
    public ContainerMetrics buildLastContainer() {
        return this.containers.get(this.containers.size() - 1).build();
    }

    @Override
    public ContainerMetrics buildMatchingContainer(Predicate<ContainerMetricsBuilder> predicate) {
        for (ContainerMetricsBuilder item : this.containers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainer(Predicate<ContainerMetricsBuilder> predicate) {
        for (ContainerMetricsBuilder item : this.containers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainers(List<ContainerMetrics> containers) {
        if (this.containers != null) {
            this._visitables.get("containers").removeAll(this.containers);
        }
        if (containers != null) {
            this.containers = new ArrayList<ContainerMetricsBuilder>();
            for (ContainerMetrics item : containers) {
                this.addToContainers(item);
            }
        } else {
            this.containers = null;
        }
        return (A)this;
    }

    @Override
    public A withContainers(ContainerMetrics ... containers) {
        if (this.containers != null) {
            this.containers.clear();
        }
        if (containers != null) {
            for (ContainerMetrics item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainers() {
        return this.containers != null && !this.containers.isEmpty();
    }

    @Override
    public PodMetricsFluent.ContainersNested<A> addNewContainer() {
        return new ContainersNestedImpl();
    }

    @Override
    public PodMetricsFluent.ContainersNested<A> addNewContainerLike(ContainerMetrics item) {
        return new ContainersNestedImpl(-1, item);
    }

    @Override
    public PodMetricsFluent.ContainersNested<A> setNewContainerLike(int index, ContainerMetrics item) {
        return new ContainersNestedImpl(index, item);
    }

    @Override
    public PodMetricsFluent.ContainersNested<A> editContainer(int index) {
        if (this.containers.size() <= index) {
            throw new RuntimeException("Can't edit containers. Index exceeds size.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public PodMetricsFluent.ContainersNested<A> editFirstContainer() {
        if (this.containers.size() == 0) {
            throw new RuntimeException("Can't edit first containers. The list is empty.");
        }
        return this.setNewContainerLike(0, this.buildContainer(0));
    }

    @Override
    public PodMetricsFluent.ContainersNested<A> editLastContainer() {
        int index = this.containers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containers. The list is empty.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public PodMetricsFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerMetricsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containers.size(); ++i) {
            if (!predicate.apply(this.containers.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containers. No match found.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public PodMetricsFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public PodMetricsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public PodMetricsFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public PodMetricsFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public PodMetricsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public String getTimestamp() {
        return this.timestamp;
    }

    @Override
    public A withTimestamp(String timestamp) {
        this.timestamp = timestamp;
        return (A)this;
    }

    @Override
    public Boolean hasTimestamp() {
        return this.timestamp != null;
    }

    @Override
    public A withNewTimestamp(String arg1) {
        return this.withTimestamp(new String(arg1));
    }

    @Override
    public A withNewTimestamp(StringBuilder arg1) {
        return this.withTimestamp(new String(arg1));
    }

    @Override
    public A withNewTimestamp(StringBuffer arg1) {
        return this.withTimestamp(new String(arg1));
    }

    @Override
    public Duration getWindow() {
        return this.window;
    }

    @Override
    public A withWindow(Duration window) {
        this.window = window;
        return (A)this;
    }

    @Override
    public Boolean hasWindow() {
        return this.window != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodMetricsFluentImpl that = (PodMetricsFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.timestamp != null ? !this.timestamp.equals(that.timestamp) : that.timestamp != null) {
            return false;
        }
        return !(this.window != null ? !this.window.equals(that.window) : that.window != null);
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<PodMetricsFluent.MetadataNested<N>>
    implements PodMetricsFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodMetricsFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ContainersNestedImpl<N>
    extends ContainerMetricsFluentImpl<PodMetricsFluent.ContainersNested<N>>
    implements PodMetricsFluent.ContainersNested<N>,
    Nested<N> {
        private final ContainerMetricsBuilder builder;
        private final int index;

        ContainersNestedImpl(int index, ContainerMetrics item) {
            this.index = index;
            this.builder = new ContainerMetricsBuilder(this, item);
        }

        ContainersNestedImpl() {
            this.index = -1;
            this.builder = new ContainerMetricsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodMetricsFluentImpl.this.setToContainers(this.index, this.builder.build());
        }

        @Override
        public N endContainer() {
            return this.and();
        }
    }
}

