/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.admission;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.client.informers.cache.Cache;
import io.javaoperatorsdk.webhook.admission.NotAllowedException;
import io.javaoperatorsdk.webhook.admission.Operation;
import io.javaoperatorsdk.webhook.admission.validation.Validator;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.kubernetes.operator.admission.informer.InformerManager;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.FlinkSessionJob;
import org.apache.flink.kubernetes.operator.api.spec.FlinkSessionJobSpec;
import org.apache.flink.kubernetes.operator.health.CanaryResourceManager;
import org.apache.flink.kubernetes.operator.validation.FlinkResourceValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkValidator
implements Validator<HasMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkValidator.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final Set<FlinkResourceValidator> validators;
    private final InformerManager informerManager;

    public FlinkValidator(Set<FlinkResourceValidator> validators, InformerManager informerManager) {
        this.validators = validators;
        this.informerManager = informerManager;
    }

    public void validate(HasMetadata resource, Operation operation) throws NotAllowedException {
        LOG.debug("Validating resource {}", (Object)resource);
        if (CanaryResourceManager.isCanaryResource((HasMetadata)resource)) {
            return;
        }
        if ("FlinkDeployment".equals(resource.getKind())) {
            this.validateDeployment((KubernetesResource)resource);
        } else if ("FlinkSessionJob".equals(resource.getKind())) {
            this.validateSessionJob((KubernetesResource)resource);
        } else {
            throw new NotAllowedException("Unexpected resource: " + resource.getKind());
        }
    }

    private void validateDeployment(KubernetesResource resource) {
        FlinkDeployment flinkDeployment = (FlinkDeployment)objectMapper.convertValue((Object)resource, FlinkDeployment.class);
        for (FlinkResourceValidator validator : this.validators) {
            Optional validationError = validator.validateDeployment(flinkDeployment);
            if (!validationError.isPresent()) continue;
            throw new NotAllowedException((String)validationError.get());
        }
    }

    private void validateSessionJob(KubernetesResource resource) {
        FlinkSessionJob sessionJob = (FlinkSessionJob)objectMapper.convertValue((Object)resource, FlinkSessionJob.class);
        String namespace = sessionJob.getMetadata().getNamespace();
        String deploymentName = ((FlinkSessionJobSpec)sessionJob.getSpec()).getDeploymentName();
        String key = Cache.namespaceKeyFunc((String)namespace, (String)deploymentName);
        FlinkDeployment deployment = (FlinkDeployment)this.informerManager.getFlinkDepInformer(namespace).getStore().getByKey(key);
        for (FlinkResourceValidator validator : this.validators) {
            Optional validationError = validator.validateSessionJob(sessionJob, Optional.ofNullable(deployment));
            if (!validationError.isPresent()) continue;
            throw new NotAllowedException((String)validationError.get());
        }
    }
}

