/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.admission;

import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.kubernetes.operator.admission.AdmissionHandler;
import org.apache.flink.kubernetes.operator.admission.FlinkValidator;
import org.apache.flink.kubernetes.operator.admission.informer.InformerManager;
import org.apache.flink.kubernetes.operator.admission.mutator.FlinkMutator;
import org.apache.flink.kubernetes.operator.config.FlinkConfigManager;
import org.apache.flink.kubernetes.operator.config.FlinkOperatorConfiguration;
import org.apache.flink.kubernetes.operator.fs.FileSystemWatchService;
import org.apache.flink.kubernetes.operator.ssl.ReloadableSslContext;
import org.apache.flink.kubernetes.operator.utils.EnvUtils;
import org.apache.flink.kubernetes.operator.utils.MutatorUtils;
import org.apache.flink.kubernetes.operator.utils.ValidatorUtils;
import org.apache.flink.shaded.netty4.io.netty.bootstrap.ServerBootstrap;
import org.apache.flink.shaded.netty4.io.netty.channel.Channel;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInitializer;
import org.apache.flink.shaded.netty4.io.netty.channel.EventLoopGroup;
import org.apache.flink.shaded.netty4.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.flink.shaded.netty4.io.netty.channel.socket.SocketChannel;
import org.apache.flink.shaded.netty4.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpObjectAggregator;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpServerCodec;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslContext;
import org.apache.flink.shaded.netty4.io.netty.handler.stream.ChunkedWriteHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkOperatorWebhook {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkOperatorWebhook.class);
    private static final int MAX_CONTEXT_LENGTH = 0x6400000;
    private static FileSystemWatchService fileSystemWatchService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        EnvUtils.logEnvironmentInfo((Logger)LOG, (String)"Flink Kubernetes Webhook", (String[])args);
        InformerManager informerManager = new InformerManager(new KubernetesClientBuilder().build());
        FlinkConfigManager configManager = new FlinkConfigManager(informerManager::setNamespaces);
        FlinkOperatorConfiguration operatorConfig = configManager.getOperatorConfiguration();
        if (!operatorConfig.isDynamicNamespacesEnabled()) {
            informerManager.setNamespaces(operatorConfig.getWatchedNamespaces());
        }
        Set validators = ValidatorUtils.discoverValidators((FlinkConfigManager)configManager);
        Set mutators = MutatorUtils.discoverMutators((FlinkConfigManager)configManager);
        AdmissionHandler endpoint = new AdmissionHandler(new FlinkValidator(validators, informerManager), new FlinkMutator(mutators, informerManager));
        ChannelInitializer<SocketChannel> initializer = FlinkOperatorWebhook.createChannelInitializer(endpoint);
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler(initializer);
            Channel serverChannel = bootstrap.bind(FlinkOperatorWebhook.getPort()).sync().channel();
            InetSocketAddress bindAddress = (InetSocketAddress)serverChannel.localAddress();
            InetAddress inetAddress = bindAddress.getAddress();
            LOG.info("Webhook listening at {}:{}", (Object)inetAddress.getHostAddress(), (Object)bindAddress.getPort());
            serverChannel.closeFuture().sync();
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    private static int getPort() {
        String portString = EnvUtils.getRequired((String)"WEBHOOK_SERVER_PORT");
        return Integer.parseInt(portString);
    }

    private static ChannelInitializer<SocketChannel> createChannelInitializer(final AdmissionHandler admissionHandler) throws Exception {
        final SslContext sslContext = FlinkOperatorWebhook.createSslContext();
        return new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                if (sslContext != null) {
                    ch.pipeline().addLast(new ChannelHandler[]{sslContext.newHandler(ch.alloc())});
                }
                ch.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(0x6400000)});
                ch.pipeline().addLast(new ChannelHandler[]{new ChunkedWriteHandler()}).addLast(((Object)((Object)admissionHandler)).getClass().getName(), (ChannelHandler)admissionHandler);
            }
        };
    }

    private static SslContext createSslContext() throws Exception {
        Optional keystorePathOpt = EnvUtils.get((String)"WEBHOOK_KEYSTORE_FILE");
        if (keystorePathOpt.isEmpty()) {
            LOG.info("No keystore path is defined in WEBHOOK_KEYSTORE_FILE, running without ssl");
            return null;
        }
        String keystoreType = EnvUtils.getRequired((String)"WEBHOOK_KEYSTORE_TYPE");
        String keystorePassword = EnvUtils.getRequired((String)"WEBHOOK_KEYSTORE_PASSWORD");
        final ReloadableSslContext reloadableSslContext = new ReloadableSslContext((String)keystorePathOpt.get(), keystoreType, keystorePassword);
        FlinkOperatorWebhook.stopFileSystemWatchService();
        String realKeystoreFileName = Path.of((String)keystorePathOpt.get(), new String[0]).toRealPath(new LinkOption[0]).getFileName().toString();
        LOG.info("Keystore path is resolved to real filename: " + realKeystoreFileName);
        fileSystemWatchService = new FileSystemWatchService(Path.of((String)keystorePathOpt.get(), new String[0]).getParent().toString()){

            protected void onFileOrDirectoryModified(Path relativePath) {
                try {
                    LOG.info("Reloading SSL context because of certificate change");
                    reloadableSslContext.reload();
                    LOG.info("SSL context reloaded successfully");
                }
                catch (Exception e) {
                    LOG.error("SSL context reload received exception: " + e);
                }
            }
        };
        fileSystemWatchService.start();
        return reloadableSslContext;
    }

    private static void stopFileSystemWatchService() throws InterruptedException {
        if (fileSystemWatchService != null) {
            fileSystemWatchService.interrupt();
            fileSystemWatchService.join();
        }
    }
}

