/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.admission;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.admission.v1.AdmissionReview;
import io.javaoperatorsdk.webhook.admission.AdmissionController;
import io.javaoperatorsdk.webhook.admission.mutation.Mutator;
import io.javaoperatorsdk.webhook.admission.validation.Validator;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.flink.kubernetes.operator.admission.mutator.DefaultRequestMutator;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufInputStream;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFuture;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.FullHttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpHeaderValues;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMessage;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpUtil;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.LastHttpContent;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.QueryStringDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class AdmissionHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(AdmissionHandler.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    protected static final String VALIDATE_REQUEST_PATH = "/validate";
    protected static final String MUTATOR_REQUEST_PATH = "/mutate";
    private final AdmissionController<HasMetadata> validatingController;
    private final AdmissionController<HasMetadata> mutatorController;

    public AdmissionHandler(Validator<HasMetadata> validator, Mutator<HasMetadata> mutator) {
        this.validatingController = new AdmissionController(validator);
        this.mutatorController = new AdmissionController(new DefaultRequestMutator<HasMetadata>(mutator));
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest httpRequest) {
        QueryStringDecoder decoder = new QueryStringDecoder(httpRequest.uri());
        String path = decoder.path();
        if (VALIDATE_REQUEST_PATH.equals(path)) {
            ByteBuf msgContent = ((FullHttpRequest)httpRequest).content();
            try {
                ByteBufInputStream in = new ByteBufInputStream(msgContent);
                AdmissionReview review = (AdmissionReview)objectMapper.readValue((InputStream)in, AdmissionReview.class);
                AdmissionReview response = this.validatingController.handle(review);
                AdmissionHandler.sendResponse(ctx, objectMapper.writeValueAsString((Object)response));
            }
            catch (Exception e) {
                LOG.error("Failed to validate", (Throwable)e);
                this.sendError(ctx, ExceptionUtils.getStackTrace((Throwable)e));
            }
        } else if (MUTATOR_REQUEST_PATH.equals(path)) {
            ByteBuf msgContent = ((FullHttpRequest)httpRequest).content();
            try {
                ByteBufInputStream in = new ByteBufInputStream(msgContent);
                AdmissionReview review = (AdmissionReview)objectMapper.readValue((InputStream)in, AdmissionReview.class);
                AdmissionReview response = this.mutatorController.handle(review);
                AdmissionHandler.sendResponse(ctx, objectMapper.writeValueAsString((Object)response));
            }
            catch (Exception e) {
                LOG.error("Failed to mutate", (Throwable)e);
                this.sendError(ctx, ExceptionUtils.getStackTrace((Throwable)e));
            }
        } else {
            String error = String.format("Illegal path requested: %s. Only %s or %s is accepted.", path, VALIDATE_REQUEST_PATH, MUTATOR_REQUEST_PATH);
            LOG.error(error);
            this.sendError(ctx, error);
        }
    }

    private void sendError(ChannelHandlerContext ctx, String error) {
        if (ctx.channel().isActive()) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.wrappedBuffer((byte[])error.getBytes(Charset.defaultCharset())));
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.TEXT_PLAIN);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
            ctx.writeAndFlush((Object)response);
        }
    }

    public static void sendResponse(@Nonnull ChannelHandlerContext channelHandlerContext, @Nonnull String json) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
        byte[] buf = json.getBytes(Charset.defaultCharset());
        ByteBuf b = Unpooled.copiedBuffer((byte[])buf);
        HttpUtil.setContentLength((HttpMessage)response, (long)buf.length);
        channelHandlerContext.write((Object)response);
        channelHandlerContext.write((Object)b);
        ChannelFuture channelFuture = channelHandlerContext.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        CompletableFuture completableFuture = new CompletableFuture();
        channelFuture.addListener(future -> {
            if (future.isSuccess()) {
                completableFuture.complete(null);
            } else {
                completableFuture.completeExceptionally(future.cause());
            }
        });
    }
}

