/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.admission.mutator;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.informers.cache.Cache;
import io.javaoperatorsdk.webhook.admission.NotAllowedException;
import io.javaoperatorsdk.webhook.admission.Operation;
import io.javaoperatorsdk.webhook.admission.mutation.Mutator;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.kubernetes.operator.admission.informer.InformerManager;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.FlinkSessionJob;
import org.apache.flink.kubernetes.operator.api.FlinkStateSnapshot;
import org.apache.flink.kubernetes.operator.api.spec.FlinkSessionJobSpec;
import org.apache.flink.kubernetes.operator.mutator.FlinkResourceMutator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkMutator
implements Mutator<HasMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkMutator.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private final Set<FlinkResourceMutator> mutators;
    private final InformerManager informerManager;

    public FlinkMutator(Set<FlinkResourceMutator> mutators, InformerManager informerManager) {
        this.mutators = mutators;
        this.informerManager = informerManager;
    }

    public HasMetadata mutate(HasMetadata resource, Operation operation) throws NotAllowedException {
        if (operation == Operation.CREATE || operation == Operation.UPDATE) {
            LOG.debug("Mutating resource {}", (Object)resource);
            if ("FlinkSessionJob".equals(resource.getKind())) {
                return this.mutateSessionJob(resource);
            }
            if ("FlinkDeployment".equals(resource.getKind())) {
                return this.mutateDeployment(resource);
            }
            if ("FlinkStateSnapshot".equals(resource.getKind())) {
                return this.mutateStateSnapshot(resource);
            }
        }
        return resource;
    }

    private FlinkSessionJob mutateSessionJob(HasMetadata resource) {
        try {
            FlinkSessionJob sessionJob = (FlinkSessionJob)mapper.convertValue((Object)resource, FlinkSessionJob.class);
            String namespace = sessionJob.getMetadata().getNamespace();
            String deploymentName = ((FlinkSessionJobSpec)sessionJob.getSpec()).getDeploymentName();
            String key = Cache.namespaceKeyFunc((String)namespace, (String)deploymentName);
            FlinkDeployment deployment = (FlinkDeployment)this.informerManager.getFlinkDepInformer(namespace).getStore().getByKey(key);
            for (FlinkResourceMutator mutator : this.mutators) {
                sessionJob = mutator.mutateSessionJob(sessionJob, Optional.ofNullable(deployment));
            }
            return sessionJob;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private FlinkDeployment mutateDeployment(HasMetadata resource) {
        try {
            FlinkDeployment flinkDeployment = (FlinkDeployment)mapper.convertValue((Object)resource, FlinkDeployment.class);
            for (FlinkResourceMutator mutator : this.mutators) {
                flinkDeployment = mutator.mutateDeployment(flinkDeployment);
            }
            return flinkDeployment;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private FlinkStateSnapshot mutateStateSnapshot(HasMetadata resource) {
        try {
            FlinkStateSnapshot snapshot = (FlinkStateSnapshot)mapper.convertValue((Object)resource, FlinkStateSnapshot.class);
            for (FlinkResourceMutator mutator : this.mutators) {
                snapshot = mutator.mutateStateSnapshot(snapshot);
            }
            return snapshot;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

