/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.admission.mutator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.admission.v1.AdmissionRequest;
import io.fabric8.kubernetes.api.model.admission.v1.AdmissionResponse;
import io.fabric8.zjsonpatch.JsonDiff;
import io.javaoperatorsdk.webhook.admission.AdmissionRequestHandler;
import io.javaoperatorsdk.webhook.admission.AdmissionUtils;
import io.javaoperatorsdk.webhook.admission.NotAllowedException;
import io.javaoperatorsdk.webhook.admission.Operation;
import io.javaoperatorsdk.webhook.admission.mutation.Mutator;
import io.javaoperatorsdk.webhook.clone.Cloner;
import io.javaoperatorsdk.webhook.clone.ObjectMapperCloner;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class DefaultRequestMutator<T extends KubernetesResource>
implements AdmissionRequestHandler {
    private static final ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private final Mutator<T> mutator;
    private final Cloner<T> cloner;

    public DefaultRequestMutator(Mutator<T> mutator) {
        this(mutator, (Cloner<T>)new ObjectMapperCloner());
    }

    public DefaultRequestMutator(Mutator<T> mutator, Cloner<T> cloner) {
        this.mutator = mutator;
        this.cloner = cloner;
    }

    public AdmissionResponse handle(AdmissionRequest admissionRequest) {
        AdmissionResponse admissionResponse;
        Operation operation = Operation.valueOf((String)admissionRequest.getOperation());
        KubernetesResource originalResource = AdmissionUtils.getTargetResource((AdmissionRequest)admissionRequest, (Operation)operation);
        KubernetesResource clonedResource = (KubernetesResource)this.cloner.clone((Object)originalResource);
        try {
            KubernetesResource mutatedResource = this.mutator.mutate(clonedResource, operation);
            admissionResponse = DefaultRequestMutator.admissionResponseFromMutation(originalResource, mutatedResource);
        }
        catch (NotAllowedException e) {
            admissionResponse = AdmissionUtils.notAllowedExceptionToAdmissionResponse((NotAllowedException)e);
        }
        return admissionResponse;
    }

    public static AdmissionResponse admissionResponseFromMutation(KubernetesResource originalResource, KubernetesResource mutatedResource) {
        AdmissionResponse admissionResponse = new AdmissionResponse();
        admissionResponse.setAllowed(Boolean.valueOf(true));
        admissionResponse.setPatchType("JSONPatch");
        JsonNode originalResNode = mapper.valueToTree((Object)originalResource);
        JsonNode mutatedResNode = mapper.valueToTree((Object)mutatedResource);
        JsonNode diff = JsonDiff.asJson((JsonNode)originalResNode, (JsonNode)mutatedResNode);
        String base64Diff = Base64.getEncoder().encodeToString(diff.toString().getBytes(StandardCharsets.UTF_8));
        admissionResponse.setPatch(base64Diff);
        return admissionResponse;
    }
}

