/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.admission.informer;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.javaoperatorsdk.operator.api.reconciler.Constants;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.FlinkSessionJob;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformerManager {
    private static final Logger LOG = LoggerFactory.getLogger(InformerManager.class);
    private final Set<String> watchedNamespaces = ConcurrentHashMap.newKeySet();
    private final KubernetesClient kubernetesClient;
    private volatile Map<String, SharedIndexInformer<FlinkDeployment>> flinkDepInformers;
    private volatile Map<String, SharedIndexInformer<FlinkSessionJob>> flinkSessionJobInformers;

    public InformerManager(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
    }

    public SharedIndexInformer<FlinkDeployment> getFlinkDepInformer(String namespace) {
        this.initFlinkDepInformers();
        String effectiveNamespace = Constants.DEFAULT_NAMESPACES_SET.equals(this.watchedNamespaces) ? "JOSDK_ALL_NAMESPACES" : namespace;
        SharedIndexInformer<FlinkDeployment> informer = this.flinkDepInformers.get(effectiveNamespace);
        Preconditions.checkNotNull(informer, (String)String.format("The informer for %s should not be null", namespace));
        return informer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFlinkDepInformers() {
        if (this.flinkDepInformers == null) {
            InformerManager informerManager = this;
            synchronized (informerManager) {
                if (this.flinkDepInformers == null) {
                    Map<String, SharedIndexInformer<FlinkDeployment>> runnableInformers = InformerManager.createRunnableInformers(FlinkDeployment.class, this.watchedNamespaces, this.kubernetesClient);
                    for (Map.Entry<String, SharedIndexInformer<FlinkDeployment>> runnableInformer : runnableInformers.entrySet()) {
                        runnableInformer.getValue().run();
                    }
                    this.flinkDepInformers = runnableInformers;
                    LOG.info("Created FlinkDeployment informers for {}", this.flinkDepInformers.keySet());
                }
            }
        }
    }

    public SharedIndexInformer<FlinkSessionJob> getFlinkSessionJobInformer(String namespace) {
        this.initFlinkSessionJobInformers();
        String effectiveNamespace = Constants.DEFAULT_NAMESPACES_SET.equals(this.watchedNamespaces) ? "JOSDK_ALL_NAMESPACES" : namespace;
        SharedIndexInformer<FlinkSessionJob> informer = this.flinkSessionJobInformers.get(effectiveNamespace);
        Preconditions.checkNotNull(informer, (String)String.format("The informer for %s should not be null", namespace));
        return informer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFlinkSessionJobInformers() {
        if (this.flinkSessionJobInformers == null) {
            InformerManager informerManager = this;
            synchronized (informerManager) {
                if (this.flinkSessionJobInformers == null) {
                    Map<String, SharedIndexInformer<FlinkSessionJob>> runnableInformers = InformerManager.createRunnableInformers(FlinkSessionJob.class, this.watchedNamespaces, this.kubernetesClient);
                    for (Map.Entry<String, SharedIndexInformer<FlinkSessionJob>> runnableInformer : runnableInformers.entrySet()) {
                        runnableInformer.getValue().run();
                    }
                    this.flinkSessionJobInformers = runnableInformers;
                    LOG.info("Created FlinkSessionJob informers for {}", this.flinkSessionJobInformers.keySet());
                }
            }
        }
    }

    private static <CR extends HasMetadata> Map<String, SharedIndexInformer<CR>> createRunnableInformers(Class<CR> resourceClass, Set<String> effectiveNamespaces, KubernetesClient kubernetesClient) {
        if (Constants.DEFAULT_NAMESPACES_SET.equals(effectiveNamespaces)) {
            return Map.of("JOSDK_ALL_NAMESPACES", ((AnyNamespaceOperation)kubernetesClient.resources(resourceClass).inAnyNamespace()).runnableInformer(0L));
        }
        HashMap<String, SharedIndexInformer<CR>> informers = new HashMap<String, SharedIndexInformer<CR>>();
        for (String effectiveNamespace : effectiveNamespaces) {
            informers.put(effectiveNamespace, ((NonNamespaceOperation)kubernetesClient.resources(resourceClass).inNamespace(effectiveNamespace)).runnableInformer(0L));
        }
        return informers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNamespaces(Set<String> watchedNamespaces) {
        InformerManager informerManager;
        LOG.info("Setting namespaces to {}", watchedNamespaces);
        this.watchedNamespaces.clear();
        this.watchedNamespaces.addAll(watchedNamespaces);
        if (this.flinkDepInformers != null) {
            informerManager = this;
            synchronized (informerManager) {
                if (this.flinkDepInformers != null) {
                    this.flinkDepInformers.forEach((key, value) -> {
                        LOG.info("Stopping FlinkDeployment informer in {})", key);
                        value.stop();
                    });
                }
                this.flinkDepInformers = null;
            }
        }
        if (this.flinkSessionJobInformers != null) {
            informerManager = this;
            synchronized (informerManager) {
                if (this.flinkSessionJobInformers != null) {
                    this.flinkSessionJobInformers.forEach((key, value) -> {
                        LOG.info("Stopping FlinkSessionJob informer in {})", key);
                        value.stop();
                    });
                }
                this.flinkSessionJobInformers = null;
            }
        }
    }
}

