/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StandaloneKubernetesUtils {
    public static final String LABEL_TYPE_STANDALONE_TYPE = "flink-standalone-kubernetes";
    private static final String TM_DEPLOYMENT_POSTFIX = "-taskmanager";

    public static String getTaskManagerDeploymentName(String clusterId) {
        return clusterId + TM_DEPLOYMENT_POSTFIX;
    }

    public static String getJobManagerDeploymentName(String clusterId) {
        return clusterId;
    }

    public static Map<String, String> getCommonLabels(String clusterId) {
        HashMap<String, String> commonLabels = new HashMap<String, String>();
        commonLabels.put("type", LABEL_TYPE_STANDALONE_TYPE);
        commonLabels.put("app", clusterId);
        return commonLabels;
    }

    public static Map<String, String> getTaskManagerSelectors(String clusterId) {
        Map<String, String> labels = StandaloneKubernetesUtils.getCommonLabels(clusterId);
        labels.put("component", "taskmanager");
        return Collections.unmodifiableMap(labels);
    }

    public static Map<String, String> getJobManagerSelectors(String clusterId) {
        Map<String, String> labels = StandaloneKubernetesUtils.getCommonLabels(clusterId);
        labels.put("component", "jobmanager");
        return Collections.unmodifiableMap(labels);
    }
}

