/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.kubeclient.parameters;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.kubeclient.parameters.AbstractKubernetesParameters;
import org.apache.flink.kubernetes.operator.standalone.StandaloneKubernetesConfigOptionsInternal;
import org.apache.flink.kubernetes.operator.utils.StandaloneKubernetesUtils;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.util.Preconditions;

public class StandaloneKubernetesTaskManagerParameters
extends AbstractKubernetesParameters {
    private final ClusterSpecification clusterSpecification;

    public StandaloneKubernetesTaskManagerParameters(Configuration flinkConfig, ClusterSpecification clusterSpecification) {
        super(flinkConfig);
        this.clusterSpecification = clusterSpecification;
    }

    public Map<String, String> getLabels() {
        HashMap labels = new HashMap();
        labels.putAll(this.flinkConfig.getOptional(KubernetesConfigOptions.TASK_MANAGER_LABELS).orElse(Collections.emptyMap()));
        labels.putAll(this.getSelectors());
        return Collections.unmodifiableMap(labels);
    }

    public Map<String, String> getSelectors() {
        return StandaloneKubernetesUtils.getTaskManagerSelectors(this.getClusterId());
    }

    public Map<String, String> getNodeSelector() {
        return Collections.unmodifiableMap(this.flinkConfig.getOptional(KubernetesConfigOptions.TASK_MANAGER_NODE_SELECTOR).orElse(Collections.emptyMap()));
    }

    public Map<String, String> getEnvironments() {
        return new HashMap<String, String>(ConfigurationUtils.getPrefixedKeyValuePairs((String)"containerized.taskmanager.env.", (Configuration)this.flinkConfig));
    }

    public Map<String, String> getAnnotations() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.TASK_MANAGER_ANNOTATIONS).orElse(Collections.emptyMap());
    }

    public List<Map<String, String>> getTolerations() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.TASK_MANAGER_TOLERATIONS).orElse(Collections.emptyList());
    }

    public int getReplicas() {
        int replicas = (Integer)this.flinkConfig.get(StandaloneKubernetesConfigOptionsInternal.KUBERNETES_TASKMANAGER_REPLICAS);
        Preconditions.checkArgument((replicas > 0 ? 1 : 0) != 0, (String)"'%s' should not be configured less than 1.", (Object[])new Object[]{StandaloneKubernetesConfigOptionsInternal.KUBERNETES_TASKMANAGER_REPLICAS.key()});
        return replicas;
    }

    public String getServiceAccount() {
        return (String)this.flinkConfig.get(KubernetesConfigOptions.TASK_MANAGER_SERVICE_ACCOUNT);
    }

    public int getTaskManagerMemoryMB() {
        return this.clusterSpecification.getTaskManagerMemoryMB();
    }

    public double getTaskManagerCPU() {
        return this.flinkConfig.getDouble(KubernetesConfigOptions.TASK_MANAGER_CPU);
    }

    public int getRPCPort() {
        int taskManagerRpcPort = KubernetesUtils.parsePort((Configuration)this.flinkConfig, (ConfigOption)TaskManagerOptions.RPC_PORT);
        Preconditions.checkArgument((taskManagerRpcPort > 0 ? 1 : 0) != 0, (String)"%s should not be 0.", (Object[])new Object[]{TaskManagerOptions.RPC_PORT.key()});
        return taskManagerRpcPort;
    }

    public Optional<File> getPodTemplateFilePath() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.TASK_MANAGER_POD_TEMPLATE).map(File::new);
    }

    public double getMemoryLimitFactor() {
        return (Double)this.flinkConfig.get(KubernetesConfigOptions.TASK_MANAGER_MEMORY_LIMIT_FACTOR);
    }

    public double getCpuLimitFactor() {
        return (Double)this.flinkConfig.get(KubernetesConfigOptions.TASK_MANAGER_CPU_LIMIT_FACTOR);
    }

    public List<Map<String, String>> getOwnerReference() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.JOB_MANAGER_OWNER_REFERENCE).orElse(Collections.emptyList());
    }
}

