/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.kubeclient.parameters;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.deployment.application.ApplicationConfiguration;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesJobManagerParameters;
import org.apache.flink.kubernetes.operator.standalone.StandaloneKubernetesConfigOptionsInternal;
import org.apache.flink.kubernetes.operator.utils.StandaloneKubernetesUtils;
import org.apache.flink.runtime.jobgraph.SavepointConfigOptions;
import org.apache.flink.runtime.jobmanager.HighAvailabilityMode;

public class StandaloneKubernetesJobManagerParameters
extends KubernetesJobManagerParameters {
    public StandaloneKubernetesJobManagerParameters(Configuration flinkConfig, ClusterSpecification clusterSpecification) {
        super(flinkConfig, clusterSpecification);
    }

    public Map<String, String> getLabels() {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.putAll(this.getSelectors());
        labels.putAll(this.flinkConfig.getOptional(KubernetesConfigOptions.JOB_MANAGER_LABELS).orElse(Collections.emptyMap()));
        return Collections.unmodifiableMap(labels);
    }

    public Map<String, String> getSelectors() {
        return StandaloneKubernetesUtils.getJobManagerSelectors(this.getClusterId());
    }

    public Map<String, String> getCommonLabels() {
        return Collections.unmodifiableMap(StandaloneKubernetesUtils.getCommonLabels(this.getClusterId()));
    }

    public boolean isInternalServiceEnabled() {
        return true;
    }

    public boolean isApplicationCluster() {
        return ((StandaloneKubernetesConfigOptionsInternal.ClusterMode)((Object)this.flinkConfig.get(StandaloneKubernetesConfigOptionsInternal.CLUSTER_MODE))).equals((Object)StandaloneKubernetesConfigOptionsInternal.ClusterMode.APPLICATION);
    }

    public String getMainClass() {
        if (!this.isApplicationCluster()) {
            return null;
        }
        return this.flinkConfig.getString(ApplicationConfiguration.APPLICATION_MAIN_CLASS);
    }

    public Boolean getAllowNonRestoredState() {
        if (this.flinkConfig.contains(SavepointConfigOptions.SAVEPOINT_IGNORE_UNCLAIMED_STATE)) {
            return (Boolean)this.flinkConfig.get(SavepointConfigOptions.SAVEPOINT_IGNORE_UNCLAIMED_STATE);
        }
        return null;
    }

    public String getSavepointPath() {
        if (this.flinkConfig.contains(SavepointConfigOptions.SAVEPOINT_PATH)) {
            return (String)this.flinkConfig.get(SavepointConfigOptions.SAVEPOINT_PATH);
        }
        return null;
    }

    public boolean isPipelineClasspathDefined() {
        return this.flinkConfig.contains(PipelineOptions.CLASSPATHS);
    }

    public List<String> getJobSpecArgs() {
        if (this.flinkConfig.contains(ApplicationConfiguration.APPLICATION_ARGS)) {
            return (List)this.flinkConfig.get(ApplicationConfiguration.APPLICATION_ARGS);
        }
        return null;
    }

    public boolean isHAEnabled() {
        return HighAvailabilityMode.isHighAvailabilityModeActivated((Configuration)this.flinkConfig);
    }
}

