/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.kubeclient.decorators;

import java.util.List;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.operator.kubeclient.parameters.StandaloneKubernetesJobManagerParameters;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Container;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Pod;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Volume;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.VolumeBuilder;
import org.apache.flink.util.Preconditions;

public class UserLibMountDecorator
extends AbstractKubernetesStepDecorator {
    private static final String USER_LIB_VOLUME = "user-lib-dir";
    private static final String USER_LIB_PATH = "/opt/flink/usrlib";
    private final StandaloneKubernetesJobManagerParameters kubernetesJobManagerParameters;

    public UserLibMountDecorator(StandaloneKubernetesJobManagerParameters kubernetesJobManagerParameters) {
        this.kubernetesJobManagerParameters = (StandaloneKubernetesJobManagerParameters)((Object)Preconditions.checkNotNull((Object)((Object)kubernetesJobManagerParameters)));
    }

    public FlinkPod decorateFlinkPod(FlinkPod flinkPod) {
        if (!this.kubernetesJobManagerParameters.isApplicationCluster()) {
            return flinkPod;
        }
        if (this.mainContainerHasUserLibPath(flinkPod)) {
            return flinkPod;
        }
        if (!this.kubernetesJobManagerParameters.isPipelineClasspathDefined()) {
            return flinkPod;
        }
        Volume userLibVolume = ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(USER_LIB_VOLUME)).withNewEmptyDir().endEmptyDir()).build();
        Pod pod = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(flinkPod.getPodWithoutMainContainer()).editSpec().addNewVolumeLike(userLibVolume).endVolume()).endSpec()).build();
        Container mountedMainContainer = ((ContainerBuilder)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)new ContainerBuilder(flinkPod.getMainContainer()).addNewVolumeMount().withName(USER_LIB_VOLUME)).withMountPath(USER_LIB_PATH)).endVolumeMount()).build();
        return new FlinkPod.Builder(flinkPod).withPod(pod).withMainContainer(mountedMainContainer).build();
    }

    private boolean mainContainerHasUserLibPath(FlinkPod flinkPod) {
        List volumeMounts = flinkPod.getMainContainer().getVolumeMounts();
        return volumeMounts.stream().anyMatch(volumeMount -> volumeMount.getMountPath().startsWith(USER_LIB_PATH));
    }
}

