/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.kubeclient.decorators;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesToleration;
import org.apache.flink.kubernetes.operator.kubeclient.parameters.StandaloneKubernetesTaskManagerParameters;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Container;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerPort;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.EnvVar;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.EnvVarBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ResourceRequirements;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Toleration;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.util.Preconditions;

public class InitStandaloneTaskManagerDecorator
extends AbstractKubernetesStepDecorator {
    private final StandaloneKubernetesTaskManagerParameters kubernetesTaskManagerParameters;

    public InitStandaloneTaskManagerDecorator(StandaloneKubernetesTaskManagerParameters kubernetesTaskManagerParameters) {
        this.kubernetesTaskManagerParameters = (StandaloneKubernetesTaskManagerParameters)((Object)Preconditions.checkNotNull((Object)((Object)kubernetesTaskManagerParameters)));
    }

    public FlinkPod decorateFlinkPod(FlinkPod flinkPod) {
        PodBuilder basicPodBuilder = new PodBuilder(flinkPod.getPodWithoutMainContainer());
        String serviceAccountName = this.kubernetesTaskManagerParameters.getServiceAccount();
        ((PodFluent.SpecNested)((PodFluent.SpecNested)((PodBuilder)basicPodBuilder.withApiVersion("v1")).editOrNewSpec().withServiceAccount(serviceAccountName)).withServiceAccountName(serviceAccountName)).endSpec();
        ((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)basicPodBuilder.editOrNewMetadata().addToLabels(this.kubernetesTaskManagerParameters.getLabels())).addToAnnotations(this.kubernetesTaskManagerParameters.getAnnotations())).endMetadata()).editOrNewSpec().addToImagePullSecrets(this.kubernetesTaskManagerParameters.getImagePullSecrets())).addToNodeSelector(this.kubernetesTaskManagerParameters.getNodeSelector())).addAllToTolerations((Collection)this.kubernetesTaskManagerParameters.getTolerations().stream().map(e -> (Toleration)KubernetesToleration.fromMap((Map)e).getInternalResource()).collect(Collectors.toList()))).endSpec();
        Container basicMainContainer = this.decorateMainContainer(flinkPod.getMainContainer());
        return new FlinkPod.Builder(flinkPod).withPod(basicPodBuilder.build()).withMainContainer(basicMainContainer).build();
    }

    private Container decorateMainContainer(Container container) {
        ContainerBuilder mainContainerBuilder = new ContainerBuilder(container);
        ResourceRequirements requirementsInPodTemplate = container.getResources() == null ? new ResourceRequirements() : container.getResources();
        ResourceRequirements resourceRequirements = KubernetesUtils.getResourceRequirements((ResourceRequirements)requirementsInPodTemplate, (int)this.kubernetesTaskManagerParameters.getTaskManagerMemoryMB(), (double)this.kubernetesTaskManagerParameters.getMemoryLimitFactor(), (double)this.kubernetesTaskManagerParameters.getTaskManagerCPU(), (double)this.kubernetesTaskManagerParameters.getCpuLimitFactor(), Collections.emptyMap(), Collections.emptyMap());
        String image = this.kubernetesTaskManagerParameters.getImage();
        String imagePullPolicy = this.kubernetesTaskManagerParameters.getImagePullPolicy().name();
        ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)mainContainerBuilder.withName("flink-main-container")).withImage(image)).withImagePullPolicy(imagePullPolicy)).withResources(resourceRequirements);
        ((ContainerBuilder)mainContainerBuilder.addToPorts(new ContainerPort[]{((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName("taskmanager-rpc")).withContainerPort(Integer.valueOf(this.kubernetesTaskManagerParameters.getRPCPort()))).build()})).addAllToEnv(this.getCustomizedEnvs());
        this.getFlinkLogDirEnv().ifPresent(xva$0 -> {
            ContainerBuilder cfr_ignored_0 = (ContainerBuilder)mainContainerBuilder.addToEnv(new EnvVar[]{xva$0});
        });
        return mainContainerBuilder.build();
    }

    private List<EnvVar> getCustomizedEnvs() {
        return this.kubernetesTaskManagerParameters.getEnvironments().entrySet().stream().map(kv -> ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName((String)kv.getKey())).withValue((String)kv.getValue())).build()).collect(Collectors.toList());
    }

    private Optional<EnvVar> getFlinkLogDirEnv() {
        return this.kubernetesTaskManagerParameters.getFlinkLogDirInPod().map(logDir -> new EnvVar("FLINK_LOG_DIR", logDir, null));
    }
}

