/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.kubeclient.decorators;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.operator.kubeclient.parameters.StandaloneKubernetesJobManagerParameters;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Container;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerBuilder;
import org.apache.flink.util.Preconditions;

public class CmdStandaloneJobManagerDecorator
extends AbstractKubernetesStepDecorator {
    public static final String JOBMANAGER_ENTRYPOINT_ARG = "jobmanager";
    public static final String APPLICATION_MODE_ARG = "standalone-job";
    public static final String POD_IP_ARG = String.format("$(%s)", "_POD_IP_ADDRESS");
    private final StandaloneKubernetesJobManagerParameters kubernetesJobManagerParameters;

    public CmdStandaloneJobManagerDecorator(StandaloneKubernetesJobManagerParameters kubernetesJobManagerParameters) {
        this.kubernetesJobManagerParameters = (StandaloneKubernetesJobManagerParameters)((Object)Preconditions.checkNotNull((Object)((Object)kubernetesJobManagerParameters)));
    }

    public FlinkPod decorateFlinkPod(FlinkPod flinkPod) {
        Container mainContainerWithStartCmd = this.kubernetesJobManagerParameters.isApplicationCluster() ? this.decorateApplicationContainer(flinkPod.getMainContainer()) : this.decorateSessionContainer(flinkPod.getMainContainer());
        return new FlinkPod.Builder(flinkPod).withMainContainer(mainContainerWithStartCmd).build();
    }

    private Container decorateSessionContainer(Container mainContainer) {
        ContainerBuilder containerBuilder = (ContainerBuilder)((ContainerBuilder)new ContainerBuilder(mainContainer).withCommand(new String[]{this.kubernetesJobManagerParameters.getContainerEntrypoint()})).addToArgs(new String[]{JOBMANAGER_ENTRYPOINT_ARG});
        if (this.kubernetesJobManagerParameters.isHAEnabled()) {
            containerBuilder.addToArgs(new String[]{POD_IP_ARG});
        }
        return containerBuilder.build();
    }

    private Container decorateApplicationContainer(Container mainContainer) {
        return ((ContainerBuilder)((ContainerBuilder)new ContainerBuilder(mainContainer).withCommand(new String[]{this.kubernetesJobManagerParameters.getContainerEntrypoint()})).withArgs(this.getApplicationClusterArgs())).build();
    }

    private List<String> getApplicationClusterArgs() {
        List<String> jobSpecArgs;
        String savepointPath;
        Boolean allowNonRestoredState;
        ArrayList<String> args = new ArrayList<String>();
        args.add(APPLICATION_MODE_ARG);
        String mainClass = this.kubernetesJobManagerParameters.getMainClass();
        if (mainClass != null) {
            args.add("--job-classname");
            args.add(mainClass);
        }
        if ((allowNonRestoredState = this.kubernetesJobManagerParameters.getAllowNonRestoredState()) != null && allowNonRestoredState.booleanValue()) {
            args.add("--allowNonRestoredState");
        }
        if ((savepointPath = this.kubernetesJobManagerParameters.getSavepointPath()) != null) {
            args.add("--fromSavepoint");
            args.add(savepointPath);
        }
        if (this.kubernetesJobManagerParameters.isHAEnabled()) {
            args.add("--host");
            args.add(POD_IP_ARG);
        }
        if ((jobSpecArgs = this.kubernetesJobManagerParameters.getJobSpecArgs()) != null) {
            args.addAll(this.kubernetesJobManagerParameters.getJobSpecArgs());
        }
        return args;
    }
}

