/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.kubeclient;

import java.util.concurrent.ExecutorService;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.kubeclient.Fabric8FlinkKubeClient;
import org.apache.flink.kubernetes.operator.kubeclient.FlinkStandaloneKubeClient;
import org.apache.flink.kubernetes.operator.utils.StandaloneKubernetesUtils;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.DeletionPropagation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.Deployment;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.DefaultKubernetesClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.GracePeriodConfigurable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.NamespacedKubernetesClientAdapter;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import org.apache.flink.util.Preconditions;

public class Fabric8FlinkStandaloneKubeClient
extends Fabric8FlinkKubeClient
implements FlinkStandaloneKubeClient {
    private final NamespacedKubernetesClient internalClient;

    @VisibleForTesting
    public Fabric8FlinkStandaloneKubeClient(Configuration flinkConfig, NamespacedKubernetesClient client, ExecutorService executorService) {
        super(flinkConfig, client, executorService);
        this.internalClient = (NamespacedKubernetesClient)Preconditions.checkNotNull((Object)client);
    }

    @Override
    public void createTaskManagerDeployment(Deployment tmDeployment) {
        this.internalClient.apps().deployments().create((Object)tmDeployment);
    }

    public void stopAndCleanupCluster(String clusterId) {
        ((GracePeriodConfigurable)((RollableScalableResource)this.internalClient.apps().deployments().withName(StandaloneKubernetesUtils.getJobManagerDeploymentName(clusterId))).withPropagationPolicy(DeletionPropagation.FOREGROUND)).delete();
        ((GracePeriodConfigurable)((RollableScalableResource)this.internalClient.apps().deployments().withName(StandaloneKubernetesUtils.getTaskManagerDeploymentName(clusterId))).withPropagationPolicy(DeletionPropagation.FOREGROUND)).delete();
    }

    public static Fabric8FlinkStandaloneKubeClient create(Configuration conf, ExecutorService executorService) {
        NamespacedKubernetesClientAdapter client = (NamespacedKubernetesClientAdapter)new DefaultKubernetesClient().inNamespace((String)conf.get(KubernetesConfigOptions.NAMESPACE));
        return new Fabric8FlinkStandaloneKubeClient(conf, (NamespacedKubernetesClient)client, executorService);
    }
}

