/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.kubeclient.factory;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.decorators.EnvSecretsDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.FlinkConfMountDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.HadoopConfMountDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.KerberosMountDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.KubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.MountSecretsDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.AbstractKubernetesParameters;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesOwnerReference;
import org.apache.flink.kubernetes.operator.kubeclient.decorators.CmdStandaloneTaskManagerDecorator;
import org.apache.flink.kubernetes.operator.kubeclient.decorators.InitStandaloneTaskManagerDecorator;
import org.apache.flink.kubernetes.operator.kubeclient.parameters.StandaloneKubernetesTaskManagerParameters;
import org.apache.flink.kubernetes.operator.utils.StandaloneKubernetesUtils;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Container;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.OwnerReference;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Pod;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.Deployment;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import org.apache.flink.util.Preconditions;

public class StandaloneKubernetesTaskManagerFactory {
    public static Deployment buildKubernetesTaskManagerDeployment(FlinkPod podTemplate, StandaloneKubernetesTaskManagerParameters kubernetesTaskManagerParameters) {
        KubernetesStepDecorator[] stepDecorators;
        FlinkPod flinkPod = ((FlinkPod)Preconditions.checkNotNull((Object)podTemplate)).copy();
        for (KubernetesStepDecorator stepDecorator : stepDecorators = new KubernetesStepDecorator[]{new InitStandaloneTaskManagerDecorator(kubernetesTaskManagerParameters), new EnvSecretsDecorator((AbstractKubernetesParameters)kubernetesTaskManagerParameters), new MountSecretsDecorator((AbstractKubernetesParameters)kubernetesTaskManagerParameters), new CmdStandaloneTaskManagerDecorator(kubernetesTaskManagerParameters), new HadoopConfMountDecorator((AbstractKubernetesParameters)kubernetesTaskManagerParameters), new KerberosMountDecorator((AbstractKubernetesParameters)kubernetesTaskManagerParameters), new FlinkConfMountDecorator((AbstractKubernetesParameters)kubernetesTaskManagerParameters)}) {
            flinkPod = stepDecorator.decorateFlinkPod(flinkPod);
        }
        Pod resolvedPod = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(flinkPod.getPodWithoutMainContainer()).editOrNewSpec().addToContainers(new Container[]{flinkPod.getMainContainer()})).endSpec()).build();
        return ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((DeploymentSpecFluent.TemplateNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentBuilder)new DeploymentBuilder().withApiVersion("apps/v1")).editOrNewMetadata().withName(StandaloneKubernetesUtils.getTaskManagerDeploymentName(kubernetesTaskManagerParameters.getClusterId()))).withAnnotations(kubernetesTaskManagerParameters.getAnnotations())).withLabels(kubernetesTaskManagerParameters.getLabels())).withOwnerReferences(kubernetesTaskManagerParameters.getOwnerReference().stream().map(e -> (OwnerReference)KubernetesOwnerReference.fromMap((Map)e).getInternalResource()).collect(Collectors.toList()))).endMetadata()).editOrNewSpec().withReplicas(Integer.valueOf(kubernetesTaskManagerParameters.getReplicas()))).editOrNewTemplate().withMetadata(resolvedPod.getMetadata())).withSpec(resolvedPod.getSpec())).endTemplate()).editOrNewSelector().addToMatchLabels(kubernetesTaskManagerParameters.getSelectors())).endSelector()).endSpec()).build();
    }
}

