/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.kubeclient.factory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.KubernetesJobManagerSpecification;
import org.apache.flink.kubernetes.kubeclient.decorators.EnvSecretsDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.ExternalServiceDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.FlinkConfMountDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.HadoopConfMountDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.InitJobManagerDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.InternalServiceDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.KerberosMountDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.KubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.decorators.MountSecretsDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.AbstractKubernetesParameters;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesJobManagerParameters;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesOwnerReference;
import org.apache.flink.kubernetes.operator.kubeclient.decorators.CmdStandaloneJobManagerDecorator;
import org.apache.flink.kubernetes.operator.kubeclient.decorators.UserLibMountDecorator;
import org.apache.flink.kubernetes.operator.kubeclient.parameters.StandaloneKubernetesJobManagerParameters;
import org.apache.flink.kubernetes.operator.utils.StandaloneKubernetesUtils;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Container;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.OwnerReference;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Pod;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.Deployment;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import org.apache.flink.util.Preconditions;

public class StandaloneKubernetesJobManagerFactory {
    public static KubernetesJobManagerSpecification buildKubernetesJobManagerSpecification(FlinkPod podTemplate, StandaloneKubernetesJobManagerParameters kubernetesJobManagerParameters) throws IOException {
        KubernetesStepDecorator[] stepDecorators;
        FlinkPod flinkPod = ((FlinkPod)Preconditions.checkNotNull((Object)podTemplate)).copy();
        ArrayList accompanyingResources = new ArrayList();
        for (KubernetesStepDecorator stepDecorator : stepDecorators = new KubernetesStepDecorator[]{new InitJobManagerDecorator((KubernetesJobManagerParameters)kubernetesJobManagerParameters), new EnvSecretsDecorator((AbstractKubernetesParameters)kubernetesJobManagerParameters), new MountSecretsDecorator((AbstractKubernetesParameters)kubernetesJobManagerParameters), new CmdStandaloneJobManagerDecorator(kubernetesJobManagerParameters), new InternalServiceDecorator((KubernetesJobManagerParameters)kubernetesJobManagerParameters), new ExternalServiceDecorator((KubernetesJobManagerParameters)kubernetesJobManagerParameters), new HadoopConfMountDecorator((AbstractKubernetesParameters)kubernetesJobManagerParameters), new KerberosMountDecorator((AbstractKubernetesParameters)kubernetesJobManagerParameters), new FlinkConfMountDecorator((AbstractKubernetesParameters)kubernetesJobManagerParameters), new UserLibMountDecorator(kubernetesJobManagerParameters)}) {
            flinkPod = stepDecorator.decorateFlinkPod(flinkPod);
            accompanyingResources.addAll(stepDecorator.buildAccompanyingKubernetesResources());
        }
        Deployment deployment = StandaloneKubernetesJobManagerFactory.createJobManagerDeployment(flinkPod, kubernetesJobManagerParameters);
        return new KubernetesJobManagerSpecification(deployment, accompanyingResources);
    }

    private static Deployment createJobManagerDeployment(FlinkPod flinkPod, KubernetesJobManagerParameters kubernetesJobManagerParameters) {
        Container resolvedMainContainer = flinkPod.getMainContainer();
        Pod resolvedPod = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(flinkPod.getPodWithoutMainContainer()).editOrNewSpec().addToContainers(new Container[]{resolvedMainContainer})).endSpec()).build();
        return ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((DeploymentSpecFluent.TemplateNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentBuilder)new DeploymentBuilder().withApiVersion("apps/v1")).editOrNewMetadata().withName(StandaloneKubernetesUtils.getJobManagerDeploymentName(kubernetesJobManagerParameters.getClusterId()))).withAnnotations(kubernetesJobManagerParameters.getAnnotations())).withLabels(kubernetesJobManagerParameters.getLabels())).withOwnerReferences(kubernetesJobManagerParameters.getOwnerReference().stream().map(e -> (OwnerReference)KubernetesOwnerReference.fromMap((Map)e).getInternalResource()).collect(Collectors.toList()))).endMetadata()).editOrNewSpec().withReplicas(Integer.valueOf(kubernetesJobManagerParameters.getReplicas()))).editOrNewTemplate().withMetadata(resolvedPod.getMetadata())).withSpec(resolvedPod.getSpec())).endTemplate()).editOrNewSelector().addToMatchLabels(kubernetesJobManagerParameters.getSelectors())).endSelector()).endSpec()).build();
    }
}

