/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json.glue.schema.registry;

import com.amazonaws.services.schemaregistry.common.AWSDeserializerInput;
import com.amazonaws.services.schemaregistry.common.AWSSerializerInput;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.deserializers.GlueSchemaRegistryDeserializationFacade;
import com.amazonaws.services.schemaregistry.serializers.GlueSchemaRegistrySerializationFacade;
import com.amazonaws.services.schemaregistry.utils.GlueSchemaRegistryUtils;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.aws.util.AWSGeneralUtil;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.glue.model.DataFormat;

@PublicEvolving
public class GlueSchemaRegistryJsonSchemaCoder
implements Serializable {
    private final String transportName;
    private final Map<String, Object> configs;
    private final GlueSchemaRegistrySerializationFacade glueSchemaRegistrySerializationFacade;
    private final GlueSchemaRegistryDeserializationFacade glueSchemaRegistryDeserializationFacade;

    public GlueSchemaRegistryJsonSchemaCoder(String transportName, Map<String, Object> configs) {
        this.transportName = transportName;
        this.configs = configs;
        AwsCredentialsProvider credentialsProvider = AWSGeneralUtil.getCredentialsProvider(configs);
        this.glueSchemaRegistrySerializationFacade = GlueSchemaRegistrySerializationFacade.builder().credentialProvider(credentialsProvider).glueSchemaRegistryConfiguration(new GlueSchemaRegistryConfiguration(configs)).build();
        this.glueSchemaRegistryDeserializationFacade = GlueSchemaRegistryDeserializationFacade.builder().credentialProvider(credentialsProvider).configs(configs).build();
    }

    @VisibleForTesting
    protected GlueSchemaRegistryJsonSchemaCoder(String transportName, Map<String, Object> configs, GlueSchemaRegistrySerializationFacade glueSchemaRegistrySerializationFacade, GlueSchemaRegistryDeserializationFacade glueSchemaRegistryDeserializationFacade) {
        this.transportName = transportName;
        this.configs = configs;
        this.glueSchemaRegistrySerializationFacade = glueSchemaRegistrySerializationFacade;
        this.glueSchemaRegistryDeserializationFacade = glueSchemaRegistryDeserializationFacade;
    }

    public Object deserialize(byte[] bytes) {
        return this.glueSchemaRegistryDeserializationFacade.deserialize(AWSDeserializerInput.builder().transportName(this.transportName).buffer(ByteBuffer.wrap(bytes)).build());
    }

    public byte[] registerSchemaAndSerialize(Object object) {
        String schema = this.glueSchemaRegistrySerializationFacade.getSchemaDefinition(DataFormat.JSON, object);
        String schemaName = GlueSchemaRegistryUtils.getInstance().getSchemaName(this.configs);
        schemaName = schemaName != null ? schemaName : GlueSchemaRegistryUtils.getInstance().configureSchemaNamingStrategy(this.configs).getSchemaName(this.transportName);
        UUID schemaVersionId = this.glueSchemaRegistrySerializationFacade.getOrRegisterSchemaVersion(AWSSerializerInput.builder().dataFormat(DataFormat.JSON.name()).schemaDefinition(schema).schemaName(schemaName).transportName(this.transportName).build());
        return this.glueSchemaRegistrySerializationFacade.serialize(DataFormat.JSON, object, schemaVersionId);
    }
}

