/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.configuration.Configuration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ParameterToolTest {
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();

    @Test(expected=RuntimeException.class)
    public void testIllegalArgs() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"berlin"});
        Assert.assertEquals((long)0L, (long)parameter.getNumberOfParameters());
    }

    @Test
    public void testNoVal() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"-berlin"});
        Assert.assertEquals((long)1L, (long)parameter.getNumberOfParameters());
        Assert.assertTrue((boolean)parameter.has("berlin"));
    }

    @Test
    public void testNoValDouble() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"--berlin"});
        Assert.assertEquals((long)1L, (long)parameter.getNumberOfParameters());
        Assert.assertTrue((boolean)parameter.has("berlin"));
    }

    @Test
    public void testMultipleNoVal() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"--a", "--b", "--c", "--d", "--e", "--f"});
        Assert.assertEquals((long)6L, (long)parameter.getNumberOfParameters());
        Assert.assertTrue((boolean)parameter.has("a"));
        Assert.assertTrue((boolean)parameter.has("b"));
        Assert.assertTrue((boolean)parameter.has("c"));
        Assert.assertTrue((boolean)parameter.has("d"));
        Assert.assertTrue((boolean)parameter.has("e"));
        Assert.assertTrue((boolean)parameter.has("f"));
    }

    @Test
    public void testMultipleNoValMixed() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"--a", "-b", "-c", "-d", "--e", "--f"});
        Assert.assertEquals((long)6L, (long)parameter.getNumberOfParameters());
        Assert.assertTrue((boolean)parameter.has("a"));
        Assert.assertTrue((boolean)parameter.has("b"));
        Assert.assertTrue((boolean)parameter.has("c"));
        Assert.assertTrue((boolean)parameter.has("d"));
        Assert.assertTrue((boolean)parameter.has("e"));
        Assert.assertTrue((boolean)parameter.has("f"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyVal() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"--a", "-b", "--"});
        Assert.assertEquals((long)2L, (long)parameter.getNumberOfParameters());
        Assert.assertTrue((boolean)parameter.has("a"));
        Assert.assertTrue((boolean)parameter.has("b"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyValShort() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"--a", "-b", "-"});
        Assert.assertEquals((long)2L, (long)parameter.getNumberOfParameters());
        Assert.assertTrue((boolean)parameter.has("a"));
        Assert.assertTrue((boolean)parameter.has("b"));
    }

    @Test
    public void testFromCliArgs() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"--input", "myInput", "-expectedCount", "15", "--withoutValues", "--negativeFloat", "-0.58", "-isWorking", "true", "--maxByte", "127", "-negativeShort", "-1024"});
        Assert.assertEquals((long)7L, (long)parameter.getNumberOfParameters());
        this.validate(parameter);
        Assert.assertTrue((boolean)parameter.has("withoutValues"));
        Assert.assertEquals((double)-0.58, (double)parameter.getFloat("negativeFloat"), (double)0.1);
        Assert.assertTrue((boolean)parameter.getBoolean("isWorking"));
        Assert.assertEquals((long)127L, (long)parameter.getByte("maxByte"));
        Assert.assertEquals((long)-1024L, (long)parameter.getShort("negativeShort"));
    }

    @Test
    public void testFromPropertiesFile() throws IOException {
        File propertiesFile = this.tmp.newFile();
        Properties props = new Properties();
        props.setProperty("input", "myInput");
        props.setProperty("expectedCount", "15");
        props.store(new FileOutputStream(propertiesFile), "Test properties");
        ParameterTool parameter = ParameterTool.fromPropertiesFile((String)propertiesFile.getAbsolutePath());
        Assert.assertEquals((long)2L, (long)parameter.getNumberOfParameters());
        this.validate(parameter);
    }

    @Test
    public void testFromMapOrProperties() {
        Properties props = new Properties();
        props.setProperty("input", "myInput");
        props.setProperty("expectedCount", "15");
        ParameterTool parameter = ParameterTool.fromMap((Map)props);
        Assert.assertEquals((long)2L, (long)parameter.getNumberOfParameters());
        this.validate(parameter);
    }

    @Test
    public void testSystemProperties() {
        System.setProperty("input", "myInput");
        System.setProperty("expectedCount", "15");
        ParameterTool parameter = ParameterTool.fromSystemProperties();
        this.validate(parameter);
    }

    @Test
    public void testMerged() {
        ParameterTool parameter1 = ParameterTool.fromArgs((String[])new String[]{"--input", "myInput"});
        System.setProperty("expectedCount", "15");
        ParameterTool parameter2 = ParameterTool.fromSystemProperties();
        ParameterTool parameter = parameter1.mergeWith(parameter2);
        this.validate(parameter);
    }

    @Test
    public void testFromGenericOptionsParser() throws IOException {
        ParameterTool parameter = ParameterTool.fromGenericOptionsParser((String[])new String[]{"-D", "input=myInput", "-DexpectedCount=15"});
        this.validate(parameter);
    }

    private void validate(ParameterTool parameter) {
        ClosureCleaner.ensureSerializable((Object)parameter);
        Assert.assertEquals((Object)"myInput", (Object)parameter.getRequired("input"));
        Assert.assertEquals((Object)"myDefaultValue", (Object)parameter.get("output", "myDefaultValue"));
        Assert.assertEquals(null, (Object)parameter.get("whatever"));
        Assert.assertEquals((long)15L, (long)parameter.getLong("expectedCount", -1L));
        Assert.assertTrue((boolean)parameter.getBoolean("thisIsUseful", true));
        Assert.assertEquals((long)42L, (long)parameter.getByte("myDefaultByte", (byte)42));
        Assert.assertEquals((long)42L, (long)parameter.getShort("myDefaultShort", (short)42));
        Configuration config = parameter.getConfiguration();
        Assert.assertEquals((long)15L, (long)config.getLong("expectedCount", -1L));
        Properties props = parameter.getProperties();
        Assert.assertEquals((Object)"myInput", (Object)props.getProperty("input"));
        props = null;
        try {
            String pathToFile = this.tmp.newFile().getAbsolutePath();
            parameter.createPropertiesFile(pathToFile);
            Properties defaultProps = new Properties();
            defaultProps.load(new FileInputStream(pathToFile));
            Assert.assertEquals((Object)"myDefaultValue", (Object)defaultProps.get("output"));
            Assert.assertEquals((Object)"-1", (Object)defaultProps.get("expectedCount"));
            Assert.assertTrue((boolean)defaultProps.containsKey("input"));
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
            e.printStackTrace();
        }
    }
}

