/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.tuple.base;

import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public abstract class TuplePairComparatorTestBase<T extends Tuple, R extends Tuple>
extends TestLogger {
    protected abstract TypePairComparator<T, R> createComparator(boolean var1);

    protected abstract Tuple2<T[], R[]> getSortedTestData();

    @Test
    public void testEqualityWithReference() {
        try {
            TypePairComparator<T, R> comparator = this.getComparator(true);
            Tuple2<T[], R[]> data = this.getSortedData();
            for (int x = 0; x < ((Tuple[])data.f0).length; ++x) {
                comparator.setReference((Object)((Tuple[])data.f0)[x]);
                Assert.assertTrue((boolean)comparator.equalToReference((Object)((Tuple[])data.f1)[x]));
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    @Test
    public void testInequalityWithReference() {
        this.testGreatSmallAscDescWithReference(true);
        this.testGreatSmallAscDescWithReference(false);
    }

    protected void testGreatSmallAscDescWithReference(boolean ascending) {
        try {
            Tuple2<T[], R[]> data = this.getSortedData();
            TypePairComparator<T, R> comparator = this.getComparator(ascending);
            for (int x = 0; x < ((Tuple[])data.f0).length - 1; ++x) {
                for (int y = x + 1; y < ((Tuple[])data.f1).length; ++y) {
                    comparator.setReference((Object)((Tuple[])data.f0)[x]);
                    if (ascending) {
                        Assert.assertTrue((comparator.compareToReference((Object)((Tuple[])data.f1)[y]) > 0 ? 1 : 0) != 0);
                        continue;
                    }
                    Assert.assertTrue((comparator.compareToReference((Object)((Tuple[])data.f1)[y]) < 0 ? 1 : 0) != 0);
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    protected TypePairComparator<T, R> getComparator(boolean ascending) {
        TypePairComparator<T, R> comparator = this.createComparator(ascending);
        if (comparator == null) {
            throw new RuntimeException("Test case corrupt. Returns null as comparator.");
        }
        return comparator;
    }

    protected Tuple2<T[], R[]> getSortedData() {
        Tuple2<T[], R[]> data = this.getSortedTestData();
        if (data == null || data.f0 == null || data.f1 == null) {
            throw new RuntimeException("Test case corrupt. Returns null as test data.");
        }
        if (((Tuple[])data.f0).length < 2 || ((Tuple[])data.f1).length < 2) {
            throw new RuntimeException("Test case does not provide enough sorted test data.");
        }
        return data;
    }
}

