/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeInfoParser;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.api.java.typeutils.WritableTypeInfo;
import org.apache.flink.types.BooleanValue;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.CharValue;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.FloatValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.ListValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.MapValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.types.ShortValue;
import org.apache.flink.types.StringValue;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class TypeInfoParserTest {
    @Test
    public void testBasicTypes() {
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)TypeInfoParser.parse((String)"Integer"));
        Assert.assertEquals((Object)BasicTypeInfo.DOUBLE_TYPE_INFO, (Object)TypeInfoParser.parse((String)"Double"));
        Assert.assertEquals((Object)BasicTypeInfo.BYTE_TYPE_INFO, (Object)TypeInfoParser.parse((String)"Byte"));
        Assert.assertEquals((Object)BasicTypeInfo.FLOAT_TYPE_INFO, (Object)TypeInfoParser.parse((String)"Float"));
        Assert.assertEquals((Object)BasicTypeInfo.SHORT_TYPE_INFO, (Object)TypeInfoParser.parse((String)"Short"));
        Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)TypeInfoParser.parse((String)"Long"));
        Assert.assertEquals((Object)BasicTypeInfo.CHAR_TYPE_INFO, (Object)TypeInfoParser.parse((String)"Character"));
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)TypeInfoParser.parse((String)"String"));
        Assert.assertEquals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO, (Object)TypeInfoParser.parse((String)"Boolean"));
        Assert.assertEquals((Object)BasicTypeInfo.VOID_TYPE_INFO, (Object)TypeInfoParser.parse((String)"Void"));
        Assert.assertEquals((Object)BasicTypeInfo.DATE_TYPE_INFO, (Object)TypeInfoParser.parse((String)"Date"));
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)TypeInfoParser.parse((String)"java.lang.Integer"));
        Assert.assertEquals((Object)BasicTypeInfo.DOUBLE_TYPE_INFO, (Object)TypeInfoParser.parse((String)"java.lang.Double"));
        Assert.assertEquals((Object)BasicTypeInfo.BYTE_TYPE_INFO, (Object)TypeInfoParser.parse((String)"java.lang.Byte"));
        Assert.assertEquals((Object)BasicTypeInfo.FLOAT_TYPE_INFO, (Object)TypeInfoParser.parse((String)"java.lang.Float"));
        Assert.assertEquals((Object)BasicTypeInfo.SHORT_TYPE_INFO, (Object)TypeInfoParser.parse((String)"java.lang.Short"));
        Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)TypeInfoParser.parse((String)"java.lang.Long"));
        Assert.assertEquals((Object)BasicTypeInfo.CHAR_TYPE_INFO, (Object)TypeInfoParser.parse((String)"java.lang.Character"));
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)TypeInfoParser.parse((String)"java.lang.String"));
        Assert.assertEquals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO, (Object)TypeInfoParser.parse((String)"java.lang.Boolean"));
        Assert.assertEquals((Object)BasicTypeInfo.VOID_TYPE_INFO, (Object)TypeInfoParser.parse((String)"java.lang.Void"));
        Assert.assertEquals((Object)BasicTypeInfo.DATE_TYPE_INFO, (Object)TypeInfoParser.parse((String)"java.util.Date"));
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)TypeInfoParser.parse((String)"int"));
        Assert.assertEquals((Object)BasicTypeInfo.DOUBLE_TYPE_INFO, (Object)TypeInfoParser.parse((String)"double"));
        Assert.assertEquals((Object)BasicTypeInfo.BYTE_TYPE_INFO, (Object)TypeInfoParser.parse((String)"byte"));
        Assert.assertEquals((Object)BasicTypeInfo.FLOAT_TYPE_INFO, (Object)TypeInfoParser.parse((String)"float"));
        Assert.assertEquals((Object)BasicTypeInfo.SHORT_TYPE_INFO, (Object)TypeInfoParser.parse((String)"short"));
        Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)TypeInfoParser.parse((String)"long"));
        Assert.assertEquals((Object)BasicTypeInfo.CHAR_TYPE_INFO, (Object)TypeInfoParser.parse((String)"char"));
        Assert.assertEquals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO, (Object)TypeInfoParser.parse((String)"boolean"));
        Assert.assertEquals((Object)BasicTypeInfo.VOID_TYPE_INFO, (Object)TypeInfoParser.parse((String)"void"));
    }

    @Test
    public void testValueTypes() {
        TypeInfoParserTest.helperValueType("StringValue", StringValue.class);
        TypeInfoParserTest.helperValueType("IntValue", IntValue.class);
        TypeInfoParserTest.helperValueType("ByteValue", ByteValue.class);
        TypeInfoParserTest.helperValueType("ShortValue", ShortValue.class);
        TypeInfoParserTest.helperValueType("CharValue", CharValue.class);
        TypeInfoParserTest.helperValueType("DoubleValue", DoubleValue.class);
        TypeInfoParserTest.helperValueType("FloatValue", FloatValue.class);
        TypeInfoParserTest.helperValueType("LongValue", LongValue.class);
        TypeInfoParserTest.helperValueType("BooleanValue", BooleanValue.class);
        TypeInfoParserTest.helperValueType("ListValue", ListValue.class);
        TypeInfoParserTest.helperValueType("MapValue", MapValue.class);
        TypeInfoParserTest.helperValueType("NullValue", NullValue.class);
    }

    private static void helperValueType(String str, Class<?> clazz) {
        TypeInformation ti = TypeInfoParser.parse((String)str);
        Assert.assertTrue((boolean)(ti instanceof ValueTypeInfo));
        ValueTypeInfo vti = (ValueTypeInfo)ti;
        Assert.assertEquals(clazz, (Object)vti.getTypeClass());
    }

    @Test
    public void testBasicArrays() {
        Assert.assertEquals((Object)BasicArrayTypeInfo.INT_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"Integer[]"));
        Assert.assertEquals((Object)BasicArrayTypeInfo.DOUBLE_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"Double[]"));
        Assert.assertEquals((Object)BasicArrayTypeInfo.BYTE_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"Byte[]"));
        Assert.assertEquals((Object)BasicArrayTypeInfo.FLOAT_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"Float[]"));
        Assert.assertEquals((Object)BasicArrayTypeInfo.SHORT_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"Short[]"));
        Assert.assertEquals((Object)BasicArrayTypeInfo.LONG_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"Long[]"));
        Assert.assertEquals((Object)BasicArrayTypeInfo.CHAR_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"Character[]"));
        Assert.assertEquals((Object)BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"String[]"));
        Assert.assertEquals((Object)BasicArrayTypeInfo.BOOLEAN_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"Boolean[]"));
        Assert.assertEquals((Object)BasicArrayTypeInfo.INT_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"java.lang.Integer[]"));
        Assert.assertEquals((Object)BasicArrayTypeInfo.DOUBLE_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"java.lang.Double[]"));
        Assert.assertEquals((Object)BasicArrayTypeInfo.BYTE_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"java.lang.Byte[]"));
        Assert.assertEquals((Object)BasicArrayTypeInfo.FLOAT_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"java.lang.Float[]"));
        Assert.assertEquals((Object)BasicArrayTypeInfo.SHORT_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"java.lang.Short[]"));
        Assert.assertEquals((Object)BasicArrayTypeInfo.LONG_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"java.lang.Long[]"));
        Assert.assertEquals((Object)BasicArrayTypeInfo.CHAR_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"java.lang.Character[]"));
        Assert.assertEquals((Object)BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"java.lang.String[]"));
        Assert.assertEquals((Object)BasicArrayTypeInfo.BOOLEAN_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"java.lang.Boolean[]"));
        Assert.assertEquals((Object)PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"int[]"));
        Assert.assertEquals((Object)PrimitiveArrayTypeInfo.DOUBLE_PRIMITIVE_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"double[]"));
        Assert.assertEquals((Object)PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"byte[]"));
        Assert.assertEquals((Object)PrimitiveArrayTypeInfo.FLOAT_PRIMITIVE_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"float[]"));
        Assert.assertEquals((Object)PrimitiveArrayTypeInfo.SHORT_PRIMITIVE_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"short[]"));
        Assert.assertEquals((Object)PrimitiveArrayTypeInfo.LONG_PRIMITIVE_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"long[]"));
        Assert.assertEquals((Object)PrimitiveArrayTypeInfo.CHAR_PRIMITIVE_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"char[]"));
        Assert.assertEquals((Object)PrimitiveArrayTypeInfo.BOOLEAN_PRIMITIVE_ARRAY_TYPE_INFO, (Object)TypeInfoParser.parse((String)"boolean[]"));
    }

    @Test
    public void testTuples() {
        TypeInformation ti = TypeInfoParser.parse((String)"Tuple2<Integer, Long>");
        Assert.assertEquals((long)2L, (long)ti.getArity());
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)((TupleTypeInfo)ti).getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)((TupleTypeInfo)ti).getTypeAt(1));
        ti = TypeInfoParser.parse((String)"Tuple0");
        Assert.assertEquals((long)0L, (long)ti.getArity());
        Assert.assertEquals((Object)"Java Tuple0", (Object)ti.toString());
        ti = TypeInfoParser.parse((String)"org.apache.flink.api.java.tuple.Tuple0");
        Assert.assertEquals((long)0L, (long)ti.getArity());
        Assert.assertEquals((Object)"Java Tuple0", (Object)ti.toString());
        ti = TypeInfoParser.parse((String)"Tuple3<Tuple1<String>, Tuple1<Integer>, Tuple2<Long, Long>>");
        Assert.assertEquals((Object)"Java Tuple3<Java Tuple1<String>, Java Tuple1<Integer>, Java Tuple2<Long, Long>>", (Object)ti.toString());
    }

    @Test
    public void testGenericType() {
        TypeInformation ti = TypeInfoParser.parse((String)"java.lang.Class");
        Assert.assertTrue((boolean)(ti instanceof GenericTypeInfo));
        Assert.assertEquals(Class.class, (Object)((GenericTypeInfo)ti).getTypeClass());
    }

    @Test
    public void testPojoType() {
        TypeInformation ti = TypeInfoParser.parse((String)"org.apache.flink.api.java.typeutils.TypeInfoParserTest$MyPojo<basic=Integer,tuple=Tuple2<String, Integer>,hadoopCitizen=Writable<org.apache.flink.api.java.typeutils.TypeInfoParserTest$MyWritable>,array=String[]>");
        Assert.assertTrue((boolean)(ti instanceof PojoTypeInfo));
        PojoTypeInfo pti = (PojoTypeInfo)ti;
        Assert.assertEquals((Object)"array", (Object)pti.getPojoFieldAt(0).getField().getName());
        Assert.assertTrue((boolean)(pti.getPojoFieldAt(0).getTypeInformation() instanceof BasicArrayTypeInfo));
        Assert.assertEquals((Object)"basic", (Object)pti.getPojoFieldAt(1).getField().getName());
        Assert.assertTrue((boolean)(pti.getPojoFieldAt(1).getTypeInformation() instanceof BasicTypeInfo));
        Assert.assertEquals((Object)"hadoopCitizen", (Object)pti.getPojoFieldAt(2).getField().getName());
        Assert.assertTrue((boolean)(pti.getPojoFieldAt(2).getTypeInformation() instanceof WritableTypeInfo));
        Assert.assertEquals((Object)"tuple", (Object)pti.getPojoFieldAt(3).getField().getName());
        Assert.assertTrue((boolean)(pti.getPojoFieldAt(3).getTypeInformation() instanceof TupleTypeInfo));
    }

    @Test
    public void testPojoType2() {
        TypeInformation ti = TypeInfoParser.parse((String)"Tuple2<String,Tuple2<Integer,org.apache.flink.api.java.typeutils.TypeInfoParserTest$MyPojo<basic=String>>>");
        Assert.assertTrue((boolean)(ti instanceof TupleTypeInfo));
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertTrue((boolean)(tti.getTypeAt(0) instanceof BasicTypeInfo));
        Assert.assertTrue((boolean)(tti.getTypeAt(1) instanceof TupleTypeInfo));
        TupleTypeInfo tti2 = (TupleTypeInfo)tti.getTypeAt(1);
        Assert.assertTrue((boolean)(tti2.getTypeAt(0) instanceof BasicTypeInfo));
        Assert.assertTrue((boolean)(tti2.getTypeAt(1) instanceof PojoTypeInfo));
        PojoTypeInfo pti = (PojoTypeInfo)tti2.getTypeAt(1);
        Assert.assertEquals((Object)"basic", (Object)pti.getPojoFieldAt(0).getField().getName());
        Assert.assertTrue((boolean)(pti.getPojoFieldAt(0).getTypeInformation() instanceof BasicTypeInfo));
    }

    @Test
    public void testWritableType() {
        TypeInformation ti = TypeInfoParser.parse((String)"Writable<org.apache.flink.api.java.typeutils.TypeInfoParserTest$MyWritable>");
        Assert.assertTrue((boolean)(ti instanceof WritableTypeInfo));
        Assert.assertEquals(MyWritable.class, (Object)((WritableTypeInfo)ti).getTypeClass());
    }

    @Test
    public void testObjectArrays() {
        TypeInformation ti = TypeInfoParser.parse((String)"java.lang.Class[]");
        Assert.assertTrue((boolean)(ti instanceof ObjectArrayTypeInfo));
        Assert.assertEquals(Class.class, (Object)((ObjectArrayTypeInfo)ti).getComponentInfo().getTypeClass());
        TypeInformation ti2 = TypeInfoParser.parse((String)"Tuple2<Integer,Double>[]");
        Assert.assertTrue((boolean)(ti2 instanceof ObjectArrayTypeInfo));
        Assert.assertTrue((boolean)(((ObjectArrayTypeInfo)ti2).getComponentInfo() instanceof TupleTypeInfo));
        TypeInformation ti3 = TypeInfoParser.parse((String)"Tuple2<Integer[],Double>[]");
        Assert.assertEquals((Object)"ObjectArrayTypeInfo<Java Tuple2<BasicArrayTypeInfo<Integer>, Double>>", (Object)ti3.toString());
    }

    @Test
    public void testLargeMixedTuple() {
        TypeInformation ti = TypeInfoParser.parse((String)"org.apache.flink.api.java.tuple.Tuple4<Double,java.lang.Class[],StringValue,Tuple1<int>>[]");
        Assert.assertEquals((Object)"ObjectArrayTypeInfo<Java Tuple4<Double, ObjectArrayTypeInfo<GenericType<java.lang.Class>>, ValueType<StringValue>, Java Tuple1<Integer>>>", (Object)ti.toString());
    }

    @Test
    public void testEnumType() {
        TypeInformation ti = TypeInfoParser.parse((String)"Enum<org.apache.flink.api.java.typeutils.TypeInfoParserTest$MyEnum>");
        Assert.assertEquals((Object)"EnumTypeInfo<org.apache.flink.api.java.typeutils.TypeInfoParserTest$MyEnum>", (Object)ti.toString());
        TypeInformation ti2 = TypeInfoParser.parse((String)"java.lang.Enum<org.apache.flink.api.java.typeutils.TypeInfoParserTest$MyEnum>");
        Assert.assertEquals((Object)"EnumTypeInfo<org.apache.flink.api.java.typeutils.TypeInfoParserTest$MyEnum>", (Object)ti2.toString());
    }

    @Test
    public void testException() {
        try {
            TypeInfoParser.parse((String)"THIS_CLASS_DOES_NOT_EXIST");
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TypeInfoParser.parse((String)"Tuple2<Integer>");
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TypeInfoParser.parse((String)"Tuple3<Integer,,>");
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TypeInfoParser.parse((String)"Tuple1<Integer,Double>");
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMultiDimensionalArray() {
        TypeInformation ti = TypeInfoParser.parse((String)"Tuple2<Integer, Double>[][]");
        Assert.assertEquals((Object)"ObjectArrayTypeInfo<ObjectArrayTypeInfo<Java Tuple2<Integer, Double>>>", (Object)ti.toString());
        ti = TypeInfoParser.parse((String)"org.apache.flink.api.java.typeutils.TypeInfoParserTest$MyPojo<basic=String>[][][]");
        Assert.assertEquals((Object)"ObjectArrayTypeInfo<ObjectArrayTypeInfo<ObjectArrayTypeInfo<PojoType<org.apache.flink.api.java.typeutils.TypeInfoParserTest$MyPojo, fields = [basic: String]>>>>", (Object)ti.toString());
        ti = TypeInfoParser.parse((String)"Float[][][]");
        Assert.assertEquals((Object)"ObjectArrayTypeInfo<ObjectArrayTypeInfo<BasicArrayTypeInfo<Float>>>", (Object)ti.toString());
        ti = TypeInfoParser.parse((String)"String[][][]");
        Assert.assertEquals((Object)"ObjectArrayTypeInfo<ObjectArrayTypeInfo<BasicArrayTypeInfo<String>>>", (Object)ti.toString());
        ti = TypeInfoParser.parse((String)"Date[][][]");
        Assert.assertEquals((Object)"ObjectArrayTypeInfo<ObjectArrayTypeInfo<ObjectArrayTypeInfo<Date>>>", (Object)ti.toString());
        ti = TypeInfoParser.parse((String)"int[][][]");
        Assert.assertEquals((Object)"ObjectArrayTypeInfo<ObjectArrayTypeInfo<int[]>>", (Object)ti.toString());
        ti = TypeInfoParser.parse((String)"boolean[][][]");
        Assert.assertEquals((Object)"ObjectArrayTypeInfo<ObjectArrayTypeInfo<boolean[]>>", (Object)ti.toString());
        ti = TypeInfoParser.parse((String)"IntValue[][][]");
        Assert.assertEquals((Object)"ObjectArrayTypeInfo<ObjectArrayTypeInfo<ObjectArrayTypeInfo<ValueType<IntValue>>>>", (Object)ti.toString());
        ti = TypeInfoParser.parse((String)"Writable<org.apache.flink.api.java.typeutils.TypeInfoParserTest$MyWritable>[][][]");
        Assert.assertEquals((Object)"ObjectArrayTypeInfo<ObjectArrayTypeInfo<ObjectArrayTypeInfo<WritableType<org.apache.flink.api.java.typeutils.TypeInfoParserTest$MyWritable>>>>", (Object)ti.toString());
        ti = TypeInfoParser.parse((String)"Enum<org.apache.flink.api.java.typeutils.TypeInfoParserTest$MyEnum>[][][]");
        Assert.assertEquals((Object)"ObjectArrayTypeInfo<ObjectArrayTypeInfo<ObjectArrayTypeInfo<EnumTypeInfo<org.apache.flink.api.java.typeutils.TypeInfoParserTest$MyEnum>>>>", (Object)ti.toString());
    }

    public static enum MyEnum {
        ONE,
        TWO,
        THREE;

    }

    public static class MyWritable
    implements Writable {
        public void write(DataOutput out) throws IOException {
        }

        public void readFields(DataInput in) throws IOException {
        }
    }

    public static class MyPojo {
        public Integer basic;
        public Tuple2<String, Integer> tuple;
        public MyWritable hadoopCitizen;
        public String[] array;
    }
}

