/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.io.IOException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.util.InstantiationUtil;
import org.junit.Assert;
import org.junit.Test;

public class PojoTypeInfoTest {
    @Test
    public void testPojoTypeInfoEquality() {
        try {
            TypeInformation info1 = TypeExtractor.getForClass(TestPojo.class);
            TypeInformation info2 = TypeExtractor.getForClass(TestPojo.class);
            Assert.assertTrue((boolean)(info1 instanceof PojoTypeInfo));
            Assert.assertTrue((boolean)(info2 instanceof PojoTypeInfo));
            Assert.assertTrue((boolean)info1.equals((Object)info2));
            Assert.assertTrue((info1.hashCode() == info2.hashCode() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPojoTypeInfoInequality() {
        try {
            TypeInformation info1 = TypeExtractor.getForClass(TestPojo.class);
            TypeInformation info2 = TypeExtractor.getForClass(AlternatePojo.class);
            Assert.assertTrue((boolean)(info1 instanceof PojoTypeInfo));
            Assert.assertTrue((boolean)(info2 instanceof PojoTypeInfo));
            Assert.assertFalse((boolean)info1.equals((Object)info2));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSerializabilityOfPojoTypeInfo() throws IOException, ClassNotFoundException {
        PojoTypeInfo pojoTypeInfo = (PojoTypeInfo)TypeExtractor.getForClass(TestPojo.class);
        byte[] serializedPojoTypeInfo = InstantiationUtil.serializeObject((Object)pojoTypeInfo);
        PojoTypeInfo deserializedPojoTypeInfo = (PojoTypeInfo)InstantiationUtil.deserializeObject((byte[])serializedPojoTypeInfo, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((Object)pojoTypeInfo, (Object)deserializedPojoTypeInfo);
    }

    @Test
    public void testPrimitivePojo() {
        TypeInformation info1 = TypeExtractor.getForClass(PrimitivePojo.class);
        Assert.assertTrue((boolean)(info1 instanceof PojoTypeInfo));
    }

    @Test
    public void testUnderscorePojo() {
        TypeInformation info1 = TypeExtractor.getForClass(UnderscorePojo.class);
        Assert.assertTrue((boolean)(info1 instanceof PojoTypeInfo));
    }

    public static final class UnderscorePojo {
        private int some_int;

        public void setSomeInt(int some_int) {
            this.some_int = some_int;
        }

        public Integer getSomeInt() {
            return this.some_int;
        }
    }

    public static final class PrimitivePojo {
        private int someInt;

        public void setSomeInt(Integer someInt) {
            this.someInt = someInt;
        }

        public Integer getSomeInt() {
            return this.someInt;
        }
    }

    public static final class AlternatePojo {
        public int someInt;
        private String aString;
        public Double[] doubleArray;

        public void setaString(String aString) {
            this.aString = aString;
        }

        public String getaString() {
            return this.aString;
        }
    }

    public static final class TestPojo {
        public int someInt;
        private String aString;
        public Double[] doubleArray;

        public void setaString(String aString) {
            this.aString = aString;
        }

        public String getaString() {
            return this.aString;
        }
    }
}

