/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.junit.Assert;
import org.junit.Test;

public class CompositeTypeTest {
    private final TupleTypeInfo<?> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private final TupleTypeInfo<Tuple3<Integer, String, Long>> inNestedTuple1 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
    private final TupleTypeInfo<Tuple2<Double, Double>> inNestedTuple2 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.DOUBLE_TYPE_INFO, BasicTypeInfo.DOUBLE_TYPE_INFO});
    private final TupleTypeInfo<?> nestedTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, this.inNestedTuple1, BasicTypeInfo.INT_TYPE_INFO, this.inNestedTuple2});
    private final TupleTypeInfo<Tuple2<Integer, Tuple2<Integer, Integer>>> inNestedTuple3 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO})});
    private final TupleTypeInfo<?> deepNestedTupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, this.inNestedTuple3, BasicTypeInfo.INT_TYPE_INFO});
    private final PojoTypeInfo<?> pojoTypeInfo = (PojoTypeInfo)TypeExtractor.getForClass(MyPojo.class);
    private final TupleTypeInfo<?> pojoInTupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, this.pojoTypeInfo});

    @Test
    public void testGetFlatFields() {
        Assert.assertEquals((long)0L, (long)((CompositeType.FlatFieldDescriptor)this.tupleTypeInfo.getFlatFields("0").get(0)).getPosition());
        Assert.assertEquals((long)1L, (long)((CompositeType.FlatFieldDescriptor)this.tupleTypeInfo.getFlatFields("1").get(0)).getPosition());
        Assert.assertEquals((long)2L, (long)((CompositeType.FlatFieldDescriptor)this.tupleTypeInfo.getFlatFields("2").get(0)).getPosition());
        Assert.assertEquals((long)3L, (long)((CompositeType.FlatFieldDescriptor)this.tupleTypeInfo.getFlatFields("3").get(0)).getPosition());
        Assert.assertEquals((long)0L, (long)((CompositeType.FlatFieldDescriptor)this.tupleTypeInfo.getFlatFields("f0").get(0)).getPosition());
        Assert.assertEquals((long)1L, (long)((CompositeType.FlatFieldDescriptor)this.tupleTypeInfo.getFlatFields("f1").get(0)).getPosition());
        Assert.assertEquals((long)2L, (long)((CompositeType.FlatFieldDescriptor)this.tupleTypeInfo.getFlatFields("f2").get(0)).getPosition());
        Assert.assertEquals((long)3L, (long)((CompositeType.FlatFieldDescriptor)this.tupleTypeInfo.getFlatFields("f3").get(0)).getPosition());
        Assert.assertEquals((long)0L, (long)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("0").get(0)).getPosition());
        Assert.assertEquals((long)1L, (long)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("1.0").get(0)).getPosition());
        Assert.assertEquals((long)2L, (long)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("1.1").get(0)).getPosition());
        Assert.assertEquals((long)3L, (long)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("1.2").get(0)).getPosition());
        Assert.assertEquals((long)4L, (long)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("2").get(0)).getPosition());
        Assert.assertEquals((long)5L, (long)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("3.0").get(0)).getPosition());
        Assert.assertEquals((long)6L, (long)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("3.1").get(0)).getPosition());
        Assert.assertEquals((long)4L, (long)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("f2").get(0)).getPosition());
        Assert.assertEquals((long)5L, (long)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("f3.f0").get(0)).getPosition());
        Assert.assertEquals((long)3L, (long)this.nestedTypeInfo.getFlatFields("1").size());
        Assert.assertEquals((long)1L, (long)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("1").get(0)).getPosition());
        Assert.assertEquals((long)2L, (long)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("1").get(1)).getPosition());
        Assert.assertEquals((long)3L, (long)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("1").get(2)).getPosition());
        Assert.assertEquals((long)3L, (long)this.nestedTypeInfo.getFlatFields("1.*").size());
        Assert.assertEquals((long)1L, (long)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("1.*").get(0)).getPosition());
        Assert.assertEquals((long)2L, (long)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("1.*").get(1)).getPosition());
        Assert.assertEquals((long)3L, (long)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("1.*").get(2)).getPosition());
        Assert.assertEquals((long)2L, (long)this.nestedTypeInfo.getFlatFields("3").size());
        Assert.assertEquals((long)5L, (long)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("3").get(0)).getPosition());
        Assert.assertEquals((long)6L, (long)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("3").get(1)).getPosition());
        Assert.assertEquals((long)3L, (long)this.nestedTypeInfo.getFlatFields("f1").size());
        Assert.assertEquals((long)1L, (long)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("f1").get(0)).getPosition());
        Assert.assertEquals((long)2L, (long)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("f1").get(1)).getPosition());
        Assert.assertEquals((long)3L, (long)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("f1").get(2)).getPosition());
        Assert.assertEquals((long)2L, (long)this.nestedTypeInfo.getFlatFields("f3").size());
        Assert.assertEquals((long)5L, (long)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("f3").get(0)).getPosition());
        Assert.assertEquals((long)6L, (long)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("f3").get(1)).getPosition());
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("0").get(0)).getType());
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("1.1").get(0)).getType());
        Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("1").get(2)).getType());
        Assert.assertEquals((Object)BasicTypeInfo.DOUBLE_TYPE_INFO, (Object)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("3").get(1)).getType());
        Assert.assertEquals((long)3L, (long)this.deepNestedTupleTypeInfo.getFlatFields("1").size());
        Assert.assertEquals((long)1L, (long)((CompositeType.FlatFieldDescriptor)this.deepNestedTupleTypeInfo.getFlatFields("1").get(0)).getPosition());
        Assert.assertEquals((long)2L, (long)((CompositeType.FlatFieldDescriptor)this.deepNestedTupleTypeInfo.getFlatFields("1").get(1)).getPosition());
        Assert.assertEquals((long)3L, (long)((CompositeType.FlatFieldDescriptor)this.deepNestedTupleTypeInfo.getFlatFields("1").get(2)).getPosition());
        Assert.assertEquals((long)5L, (long)this.deepNestedTupleTypeInfo.getFlatFields("*").size());
        Assert.assertEquals((long)0L, (long)((CompositeType.FlatFieldDescriptor)this.deepNestedTupleTypeInfo.getFlatFields("*").get(0)).getPosition());
        Assert.assertEquals((long)1L, (long)((CompositeType.FlatFieldDescriptor)this.deepNestedTupleTypeInfo.getFlatFields("*").get(1)).getPosition());
        Assert.assertEquals((long)2L, (long)((CompositeType.FlatFieldDescriptor)this.deepNestedTupleTypeInfo.getFlatFields("*").get(2)).getPosition());
        Assert.assertEquals((long)3L, (long)((CompositeType.FlatFieldDescriptor)this.deepNestedTupleTypeInfo.getFlatFields("*").get(3)).getPosition());
        Assert.assertEquals((long)4L, (long)((CompositeType.FlatFieldDescriptor)this.deepNestedTupleTypeInfo.getFlatFields("*").get(4)).getPosition());
        Assert.assertEquals((long)0L, (long)((CompositeType.FlatFieldDescriptor)this.pojoTypeInfo.getFlatFields("a").get(0)).getPosition());
        Assert.assertEquals((long)1L, (long)((CompositeType.FlatFieldDescriptor)this.pojoTypeInfo.getFlatFields("b").get(0)).getPosition());
        Assert.assertEquals((long)2L, (long)this.pojoTypeInfo.getFlatFields("*").size());
        Assert.assertEquals((long)0L, (long)((CompositeType.FlatFieldDescriptor)this.pojoTypeInfo.getFlatFields("*").get(0)).getPosition());
        Assert.assertEquals((long)1L, (long)((CompositeType.FlatFieldDescriptor)this.pojoTypeInfo.getFlatFields("*").get(1)).getPosition());
        Assert.assertEquals((long)1L, (long)((CompositeType.FlatFieldDescriptor)this.pojoInTupleTypeInfo.getFlatFields("f1.a").get(0)).getPosition());
        Assert.assertEquals((long)2L, (long)((CompositeType.FlatFieldDescriptor)this.pojoInTupleTypeInfo.getFlatFields("1.b").get(0)).getPosition());
        Assert.assertEquals((long)2L, (long)this.pojoInTupleTypeInfo.getFlatFields("1").size());
        Assert.assertEquals((long)1L, (long)((CompositeType.FlatFieldDescriptor)this.pojoInTupleTypeInfo.getFlatFields("1.*").get(0)).getPosition());
        Assert.assertEquals((long)2L, (long)((CompositeType.FlatFieldDescriptor)this.pojoInTupleTypeInfo.getFlatFields("1").get(1)).getPosition());
        Assert.assertEquals((long)2L, (long)this.pojoInTupleTypeInfo.getFlatFields("f1.*").size());
        Assert.assertEquals((long)1L, (long)((CompositeType.FlatFieldDescriptor)this.pojoInTupleTypeInfo.getFlatFields("f1.*").get(0)).getPosition());
        Assert.assertEquals((long)2L, (long)((CompositeType.FlatFieldDescriptor)this.pojoInTupleTypeInfo.getFlatFields("f1").get(1)).getPosition());
        Assert.assertEquals((long)3L, (long)this.pojoInTupleTypeInfo.getFlatFields("*").size());
        Assert.assertEquals((long)0L, (long)((CompositeType.FlatFieldDescriptor)this.pojoInTupleTypeInfo.getFlatFields("*").get(0)).getPosition());
        Assert.assertEquals((long)1L, (long)((CompositeType.FlatFieldDescriptor)this.pojoInTupleTypeInfo.getFlatFields("*").get(1)).getPosition());
        Assert.assertEquals((long)2L, (long)((CompositeType.FlatFieldDescriptor)this.pojoInTupleTypeInfo.getFlatFields("*").get(2)).getPosition());
    }

    @Test
    public void testFieldAtStringRef() {
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)this.tupleTypeInfo.getTypeAt("0"));
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)this.tupleTypeInfo.getTypeAt("2"));
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)this.tupleTypeInfo.getTypeAt("f1"));
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)this.tupleTypeInfo.getTypeAt("f3"));
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)this.nestedTypeInfo.getTypeAt("0"));
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)this.nestedTypeInfo.getTypeAt("1.0"));
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)this.nestedTypeInfo.getTypeAt("1.1"));
        Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)this.nestedTypeInfo.getTypeAt("1.2"));
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)this.nestedTypeInfo.getTypeAt("2"));
        Assert.assertEquals((Object)BasicTypeInfo.DOUBLE_TYPE_INFO, (Object)this.nestedTypeInfo.getTypeAt("3.0"));
        Assert.assertEquals((Object)BasicTypeInfo.DOUBLE_TYPE_INFO, (Object)this.nestedTypeInfo.getTypeAt("3.1"));
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)this.nestedTypeInfo.getTypeAt("f2"));
        Assert.assertEquals((Object)BasicTypeInfo.DOUBLE_TYPE_INFO, (Object)this.nestedTypeInfo.getTypeAt("f3.f0"));
        Assert.assertEquals(this.inNestedTuple1, (Object)this.nestedTypeInfo.getTypeAt("1"));
        Assert.assertEquals(this.inNestedTuple2, (Object)this.nestedTypeInfo.getTypeAt("3"));
        Assert.assertEquals(this.inNestedTuple1, (Object)this.nestedTypeInfo.getTypeAt("f1"));
        Assert.assertEquals(this.inNestedTuple2, (Object)this.nestedTypeInfo.getTypeAt("f3"));
        Assert.assertEquals(this.inNestedTuple3, (Object)this.deepNestedTupleTypeInfo.getTypeAt("1"));
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)this.pojoTypeInfo.getTypeAt("a"));
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)this.pojoTypeInfo.getTypeAt("b"));
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)this.pojoInTupleTypeInfo.getTypeAt("f1.a"));
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)this.pojoInTupleTypeInfo.getTypeAt("1.b"));
        Assert.assertEquals(this.pojoTypeInfo, (Object)this.pojoInTupleTypeInfo.getTypeAt("1"));
        Assert.assertEquals(this.pojoTypeInfo, (Object)this.pojoInTupleTypeInfo.getTypeAt("f1"));
    }

    public static class MyPojo {
        public String a;
        public int b;
    }
}

