/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.record.io;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.apache.flink.api.java.record.io.CsvInputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.StringValue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CsvInputFormatTest {
    protected File tempFile;
    private final CsvInputFormat format = new CsvInputFormat();
    private static final String FIRST_PART = "That is the first part";
    private static final String SECOND_PART = "That is the second part";

    @Before
    public void setup() {
        this.format.setFilePath("file:///some/file/that/will/not/be/read");
    }

    @After
    public void setdown() throws Exception {
        if (this.format != null) {
            this.format.close();
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
    }

    @Test
    public void testConfigureEmptyConfig() {
        try {
            Configuration config = new Configuration();
            try {
                this.format.configure(config);
                Assert.fail();
            }
            catch (IllegalConfigurationException illegalConfigurationException) {}
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void readWithEmptyFieldInstanceParameters() {
        try {
            String fileContent = "abc|def|ghijk\nabc||hhg\n|||";
            FileInputSplit split = this.createTempFile("abc|def|ghijk\nabc||hhg\n|||");
            Configuration parameters = new Configuration();
            this.format.setFieldDelimiter('|');
            this.format.setFieldTypes(new Class[]{StringValue.class, StringValue.class, StringValue.class});
            this.format.configure(parameters);
            this.format.open(split);
            Record record = new Record();
            Assert.assertNotNull((Object)this.format.nextRecord((Object)record));
            Assert.assertEquals((Object)"abc", (Object)((StringValue)record.getField(0, StringValue.class)).getValue());
            Assert.assertEquals((Object)"def", (Object)((StringValue)record.getField(1, StringValue.class)).getValue());
            Assert.assertEquals((Object)"ghijk", (Object)((StringValue)record.getField(2, StringValue.class)).getValue());
            Assert.assertNotNull((Object)this.format.nextRecord((Object)record));
            Assert.assertEquals((Object)"abc", (Object)((StringValue)record.getField(0, StringValue.class)).getValue());
            Assert.assertEquals((Object)"", (Object)((StringValue)record.getField(1, StringValue.class)).getValue());
            Assert.assertEquals((Object)"hhg", (Object)((StringValue)record.getField(2, StringValue.class)).getValue());
            Assert.assertNotNull((Object)this.format.nextRecord((Object)record));
            Assert.assertEquals((Object)"", (Object)((StringValue)record.getField(0, StringValue.class)).getValue());
            Assert.assertEquals((Object)"", (Object)((StringValue)record.getField(1, StringValue.class)).getValue());
            Assert.assertEquals((Object)"", (Object)((StringValue)record.getField(2, StringValue.class)).getValue());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void readWithEmptyFieldConfigParameters() {
        try {
            String fileContent = "abc|def|ghijk\nabc||hhg\n|||";
            FileInputSplit split = this.createTempFile("abc|def|ghijk\nabc||hhg\n|||");
            Configuration parameters = new Configuration();
            ((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)new CsvInputFormat.ConfigBuilder(null, parameters).field(StringValue.class, 0)).field(StringValue.class, 1)).field(StringValue.class, 2);
            this.format.setFieldDelimiter("|");
            this.format.configure(parameters);
            this.format.open(split);
            Record record = new Record();
            Assert.assertNotNull((Object)this.format.nextRecord((Object)record));
            Assert.assertEquals((Object)"abc", (Object)((StringValue)record.getField(0, StringValue.class)).getValue());
            Assert.assertEquals((Object)"def", (Object)((StringValue)record.getField(1, StringValue.class)).getValue());
            Assert.assertEquals((Object)"ghijk", (Object)((StringValue)record.getField(2, StringValue.class)).getValue());
            Assert.assertNotNull((Object)this.format.nextRecord((Object)record));
            Assert.assertEquals((Object)"abc", (Object)((StringValue)record.getField(0, StringValue.class)).getValue());
            Assert.assertEquals((Object)"", (Object)((StringValue)record.getField(1, StringValue.class)).getValue());
            Assert.assertEquals((Object)"hhg", (Object)((StringValue)record.getField(2, StringValue.class)).getValue());
            Assert.assertNotNull((Object)this.format.nextRecord((Object)record));
            Assert.assertEquals((Object)"", (Object)((StringValue)record.getField(0, StringValue.class)).getValue());
            Assert.assertEquals((Object)"", (Object)((StringValue)record.getField(1, StringValue.class)).getValue());
            Assert.assertEquals((Object)"", (Object)((StringValue)record.getField(2, StringValue.class)).getValue());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testReadAll() throws IOException {
        try {
            String fileContent = "111|222|333|444|555\n666|777|888|999|000|";
            FileInputSplit split = this.createTempFile("111|222|333|444|555\n666|777|888|999|000|");
            Configuration parameters = new Configuration();
            ((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)new CsvInputFormat.ConfigBuilder(null, parameters).fieldDelimiter('|')).field(IntValue.class, 0)).field(IntValue.class, 1)).field(IntValue.class, 2)).field(IntValue.class, 3)).field(IntValue.class, 4);
            this.format.configure(parameters);
            this.format.open(split);
            Record record = new Record();
            Assert.assertNotNull((Object)this.format.nextRecord((Object)record));
            Assert.assertEquals((long)111L, (long)((IntValue)record.getField(0, IntValue.class)).getValue());
            Assert.assertEquals((long)222L, (long)((IntValue)record.getField(1, IntValue.class)).getValue());
            Assert.assertEquals((long)333L, (long)((IntValue)record.getField(2, IntValue.class)).getValue());
            Assert.assertEquals((long)444L, (long)((IntValue)record.getField(3, IntValue.class)).getValue());
            Assert.assertEquals((long)555L, (long)((IntValue)record.getField(4, IntValue.class)).getValue());
            Assert.assertNotNull((Object)this.format.nextRecord((Object)record));
            Assert.assertEquals((long)666L, (long)((IntValue)record.getField(0, IntValue.class)).getValue());
            Assert.assertEquals((long)777L, (long)((IntValue)record.getField(1, IntValue.class)).getValue());
            Assert.assertEquals((long)888L, (long)((IntValue)record.getField(2, IntValue.class)).getValue());
            Assert.assertEquals((long)999L, (long)((IntValue)record.getField(3, IntValue.class)).getValue());
            Assert.assertEquals((long)0L, (long)((IntValue)record.getField(4, IntValue.class)).getValue());
            Assert.assertNull((Object)this.format.nextRecord((Object)record));
            Assert.assertTrue((boolean)this.format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testReadFirstN() throws IOException {
        try {
            String fileContent = "111|222|333|444|555|\n666|777|888|999|000|";
            FileInputSplit split = this.createTempFile("111|222|333|444|555|\n666|777|888|999|000|");
            Configuration parameters = new Configuration();
            ((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)new CsvInputFormat.ConfigBuilder(null, parameters).fieldDelimiter('|')).field(IntValue.class, 0)).field(IntValue.class, 1);
            this.format.configure(parameters);
            this.format.open(split);
            Record record = new Record();
            Assert.assertNotNull((Object)this.format.nextRecord((Object)record));
            Assert.assertEquals((long)111L, (long)((IntValue)record.getField(0, IntValue.class)).getValue());
            Assert.assertEquals((long)222L, (long)((IntValue)record.getField(1, IntValue.class)).getValue());
            boolean notParsed = false;
            try {
                record.getField(2, IntValue.class);
            }
            catch (IndexOutOfBoundsException ioo) {
                notParsed = true;
            }
            Assert.assertTrue((boolean)notParsed);
            Assert.assertNotNull((Object)this.format.nextRecord((Object)record));
            Assert.assertEquals((long)666L, (long)((IntValue)record.getField(0, IntValue.class)).getValue());
            Assert.assertEquals((long)777L, (long)((IntValue)record.getField(1, IntValue.class)).getValue());
            notParsed = false;
            try {
                record.getField(2, IntValue.class);
            }
            catch (IndexOutOfBoundsException ioo) {
                notParsed = true;
            }
            Assert.assertTrue((boolean)notParsed);
            Assert.assertNull((Object)this.format.nextRecord((Object)record));
            Assert.assertTrue((boolean)this.format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testReadSparse() throws IOException {
        try {
            String fileContent = "111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|";
            FileInputSplit split = this.createTempFile("111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|");
            Configuration parameters = new Configuration();
            ((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)new CsvInputFormat.ConfigBuilder(null, parameters).fieldDelimiter('|')).field(IntValue.class, 0)).field(IntValue.class, 3)).field(IntValue.class, 7);
            this.format.configure(parameters);
            this.format.open(split);
            Record record = new Record();
            Assert.assertNotNull((Object)this.format.nextRecord((Object)record));
            Assert.assertEquals((long)111L, (long)((IntValue)record.getField(0, IntValue.class)).getValue());
            Assert.assertEquals((long)444L, (long)((IntValue)record.getField(1, IntValue.class)).getValue());
            Assert.assertEquals((long)888L, (long)((IntValue)record.getField(2, IntValue.class)).getValue());
            Assert.assertNotNull((Object)this.format.nextRecord((Object)record));
            Assert.assertEquals((long)0L, (long)((IntValue)record.getField(0, IntValue.class)).getValue());
            Assert.assertEquals((long)777L, (long)((IntValue)record.getField(1, IntValue.class)).getValue());
            Assert.assertEquals((long)333L, (long)((IntValue)record.getField(2, IntValue.class)).getValue());
            Assert.assertNull((Object)this.format.nextRecord((Object)record));
            Assert.assertTrue((boolean)this.format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testReadSparseShufflePosition() throws IOException {
        try {
            String fileContent = "111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|";
            FileInputSplit split = this.createTempFile("111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|");
            Configuration parameters = new Configuration();
            ((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)new CsvInputFormat.ConfigBuilder(null, parameters).fieldDelimiter('|')).field(IntValue.class, 8)).field(IntValue.class, 1)).field(IntValue.class, 3);
            this.format.configure(parameters);
            this.format.open(split);
            Record record = new Record();
            Assert.assertNotNull((Object)this.format.nextRecord((Object)record));
            Assert.assertEquals((long)999L, (long)((IntValue)record.getField(0, IntValue.class)).getValue());
            Assert.assertEquals((long)222L, (long)((IntValue)record.getField(1, IntValue.class)).getValue());
            Assert.assertEquals((long)444L, (long)((IntValue)record.getField(2, IntValue.class)).getValue());
            Assert.assertNotNull((Object)this.format.nextRecord((Object)record));
            Assert.assertEquals((long)222L, (long)((IntValue)record.getField(0, IntValue.class)).getValue());
            Assert.assertEquals((long)999L, (long)((IntValue)record.getField(1, IntValue.class)).getValue());
            Assert.assertEquals((long)777L, (long)((IntValue)record.getField(2, IntValue.class)).getValue());
            Assert.assertNull((Object)this.format.nextRecord((Object)record));
            Assert.assertTrue((boolean)this.format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    private FileInputSplit createTempFile(String content) throws IOException {
        this.tempFile = File.createTempFile("test_contents", "tmp");
        this.tempFile.deleteOnExit();
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(this.tempFile));
        dos.writeBytes(content);
        dos.close();
        return new FileInputSplit(0, new Path(this.tempFile.toURI().toString()), 0L, this.tempFile.length(), new String[]{"localhost"});
    }

    @Test
    public void testWindowsLineEndRemoval() {
        this.testRemovingTrailingCR("\n", "\n");
        this.testRemovingTrailingCR("\r\n", "\r\n");
        this.testRemovingTrailingCR("\r\n", "\n");
    }

    private void testRemovingTrailingCR(String lineBreakerInFile, String lineBreakerSetup) {
        File tempFile = null;
        String fileContent = FIRST_PART + lineBreakerInFile + SECOND_PART + lineBreakerInFile;
        try {
            tempFile = File.createTempFile("CsvInputFormatTest", "tmp");
            tempFile.deleteOnExit();
            tempFile.setWritable(true);
            OutputStreamWriter wrt = new OutputStreamWriter(new FileOutputStream(tempFile));
            wrt.write(fileContent);
            wrt.close();
            CsvInputFormat inputFormat = new CsvInputFormat();
            Configuration parameters = new Configuration();
            ((CsvInputFormat.ConfigBuilder)new CsvInputFormat.ConfigBuilder(null, parameters).field(StringValue.class, 0)).filePath(tempFile.toURI().toString());
            inputFormat.configure(parameters);
            inputFormat.setDelimiter(lineBreakerSetup);
            FileInputSplit[] splits = inputFormat.createInputSplits(1);
            inputFormat.open(splits[0]);
            Record record = new Record();
            Record result = (Record)inputFormat.nextRecord((Object)record);
            Assert.assertNotNull((String)"Expecting to not return null", (Object)result);
            Assert.assertEquals((Object)FIRST_PART, (Object)((StringValue)result.getField(0, StringValue.class)).getValue());
            result = (Record)inputFormat.nextRecord((Object)record);
            Assert.assertNotNull((String)"Expecting to not return null", (Object)result);
            Assert.assertEquals((Object)SECOND_PART, (Object)((StringValue)result.getField(0, StringValue.class)).getValue());
        }
        catch (Throwable t) {
            System.err.println("test failed with exception: " + t.getMessage());
            t.printStackTrace(System.err);
            Assert.fail((String)"Test erroneous");
        }
    }
}

