/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators.translation;

import java.io.Serializable;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.base.CoGroupOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class CoGroupSortTranslationTest
implements Serializable {
    @Test
    public void testGroupSortTuples() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)0L, (Object)0L)});
            DataSource input2 = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)0L, (Object)0L, (Object)0L)});
            input1.coGroup((DataSet)input2).where(new int[]{1}).equalTo(new int[]{2}).sortFirstGroup(0, Order.DESCENDING).sortSecondGroup(1, Order.ASCENDING).sortSecondGroup(0, Order.DESCENDING).with((CoGroupFunction)new CoGroupFunction<Tuple2<Long, Long>, Tuple3<Long, Long, Long>, Long>(){

                public void coGroup(Iterable<Tuple2<Long, Long>> first, Iterable<Tuple3<Long, Long, Long>> second, Collector<Long> out) {
                }
            }).output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            CoGroupOperatorBase coGroup = (CoGroupOperatorBase)sink.getInput();
            Assert.assertNotNull((Object)coGroup.getGroupOrderForInputOne());
            Assert.assertNotNull((Object)coGroup.getGroupOrderForInputTwo());
            Assert.assertEquals((long)1L, (long)coGroup.getGroupOrderForInputOne().getNumberOfFields());
            Assert.assertEquals((long)0L, (long)coGroup.getGroupOrderForInputOne().getFieldNumber(0).intValue());
            Assert.assertEquals((Object)Order.DESCENDING, (Object)coGroup.getGroupOrderForInputOne().getOrder(0));
            Assert.assertEquals((long)2L, (long)coGroup.getGroupOrderForInputTwo().getNumberOfFields());
            Assert.assertEquals((long)1L, (long)coGroup.getGroupOrderForInputTwo().getFieldNumber(0).intValue());
            Assert.assertEquals((long)0L, (long)coGroup.getGroupOrderForInputTwo().getFieldNumber(1).intValue());
            Assert.assertEquals((Object)Order.ASCENDING, (Object)coGroup.getGroupOrderForInputTwo().getOrder(0));
            Assert.assertEquals((Object)Order.DESCENDING, (Object)coGroup.getGroupOrderForInputTwo().getOrder(1));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSortTuplesAndPojos() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)0L, (Object)0L)});
            DataSource input2 = env.fromElements((Object[])new TestPoJo[]{new TestPoJo()});
            input1.coGroup((DataSet)input2).where(new int[]{1}).equalTo(new String[]{"b"}).sortFirstGroup(0, Order.DESCENDING).sortSecondGroup("c", Order.ASCENDING).sortSecondGroup("a", Order.DESCENDING).with((CoGroupFunction)new CoGroupFunction<Tuple2<Long, Long>, TestPoJo, Long>(){

                public void coGroup(Iterable<Tuple2<Long, Long>> first, Iterable<TestPoJo> second, Collector<Long> out) {
                }
            }).output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            CoGroupOperatorBase coGroup = (CoGroupOperatorBase)sink.getInput();
            Assert.assertNotNull((Object)coGroup.getGroupOrderForInputOne());
            Assert.assertNotNull((Object)coGroup.getGroupOrderForInputTwo());
            Assert.assertEquals((long)1L, (long)coGroup.getGroupOrderForInputOne().getNumberOfFields());
            Assert.assertEquals((long)0L, (long)coGroup.getGroupOrderForInputOne().getFieldNumber(0).intValue());
            Assert.assertEquals((Object)Order.DESCENDING, (Object)coGroup.getGroupOrderForInputOne().getOrder(0));
            Assert.assertEquals((long)2L, (long)coGroup.getGroupOrderForInputTwo().getNumberOfFields());
            Assert.assertEquals((long)2L, (long)coGroup.getGroupOrderForInputTwo().getFieldNumber(0).intValue());
            Assert.assertEquals((long)0L, (long)coGroup.getGroupOrderForInputTwo().getFieldNumber(1).intValue());
            Assert.assertEquals((Object)Order.ASCENDING, (Object)coGroup.getGroupOrderForInputTwo().getOrder(0));
            Assert.assertEquals((Object)Order.DESCENDING, (Object)coGroup.getGroupOrderForInputTwo().getOrder(1));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public static class TestPoJo {
        public long a;
        public long b;
        public long c;
    }
}

