/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.hadoop.mapreduce;

import java.io.IOException;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.hadoop.mapreduce.HadoopInputFormat;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.junit.Assert;
import org.junit.Test;

public class HadoopInputFormatTest {
    @Test
    public void checkTypeInformation() {
        try {
            Job job = Job.getInstance();
            HadoopInputFormat hadoopInputFormat = new HadoopInputFormat(new DummyVoidKeyInputFormat(), Void.class, Long.class, job);
            TypeInformation tupleType = hadoopInputFormat.getProducedType();
            TupleTypeInfo testTupleType = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.VOID_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
            if (tupleType.isTupleType()) {
                if (!((TupleTypeInfo)tupleType).equals((Object)testTupleType)) {
                    Assert.fail((String)"Tuple type information was not set correctly!");
                }
            } else {
                Assert.fail((String)"Type information was not set to tuple type information!");
            }
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    public class DummyVoidKeyInputFormat<T>
    extends FileInputFormat<Void, T> {
        public RecordReader<Void, T> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            return null;
        }
    }
}

