/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.junit.Assert;
import org.junit.Test;

public class MultipleInvokationsTest {
    @Test
    public void testMultipleInvocationsGetPlan() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            Operator data = env.fromElements((Object[])new String[]{"Some", "test", "data"}).name("source1");
            data.output((OutputFormat)new DiscardingOutputFormat()).name("print1");
            data.output((OutputFormat)new DiscardingOutputFormat()).name("output1");
            JavaPlan p = env.createProgramPlan();
            Assert.assertEquals((long)2L, (long)p.getDataSinks().size());
            for (GenericDataSinkBase sink : p.getDataSinks()) {
                Assert.assertTrue((sink.getName().equals("print1") || sink.getName().equals("output1") ? 1 : 0) != 0);
                Assert.assertEquals((Object)"source1", (Object)sink.getInput().getName());
            }
            data.writeAsText("/some/file/path").name("textsink");
            p = env.createProgramPlan();
            Assert.assertEquals((long)1L, (long)p.getDataSinks().size());
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            Assert.assertEquals((Object)"textsink", (Object)sink.getName());
            Assert.assertEquals((Object)"source1", (Object)sink.getInput().getName());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

