/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.utils;

import org.apache.flink.api.java.utils.Option;
import org.apache.flink.api.java.utils.OptionType;
import org.apache.flink.api.java.utils.RequiredParametersException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class OptionsTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testChoicesWithInvalidDefaultValue() throws RequiredParametersException {
        this.expectedException.expect(RequiredParametersException.class);
        this.expectedException.expectMessage("Default value d is not in the list of valid values for option choices");
        Option option = new Option("choices").choices(new String[]{"a", "b", "c"});
        option.defaultValue("d");
    }

    @Test
    public void testChoicesWithValidDefaultValue() {
        Option option = null;
        try {
            option = new Option("choices").choices(new String[]{"a", "b", "c"});
            option = option.defaultValue("a");
        }
        catch (RequiredParametersException e) {
            Assert.fail((String)("Exception thrown: " + e.getMessage()));
        }
        Assert.assertEquals((Object)option.getDefaultValue(), (Object)"a");
    }

    @Test
    public void testChoicesWithInvalidDefautlValue() throws RequiredParametersException {
        this.expectedException.expect(RequiredParametersException.class);
        this.expectedException.expectMessage("Valid values for option choices do not contain defined default value x");
        Option option = new Option("choices").defaultValue("x");
        option.choices(new String[]{"a", "b"});
    }

    @Test
    public void testIsCastableToDefinedTypeWithDefaultType() {
        Option option = new Option("name");
        Assert.assertTrue((boolean)option.isCastableToDefinedType("some value"));
    }

    @Test
    public void testIsCastableToDefinedTypeWithMatchingTypes() {
        Option option = new Option("name").type(OptionType.INTEGER);
        Assert.assertTrue((boolean)option.isCastableToDefinedType("15"));
        Option optionDouble = new Option("name").type(OptionType.DOUBLE);
        Assert.assertTrue((boolean)optionDouble.isCastableToDefinedType("15.0"));
        Option optionFloat = new Option("name").type(OptionType.BOOLEAN);
        Assert.assertTrue((boolean)optionFloat.isCastableToDefinedType("true"));
    }

    @Test
    public void testIsCastableToDefinedTypeWithNonMatchingTypes() {
        Option option = new Option("name").type(OptionType.INTEGER);
        Assert.assertFalse((boolean)option.isCastableToDefinedType("true"));
        Option optionDouble = new Option("name").type(OptionType.DOUBLE);
        Assert.assertFalse((boolean)optionDouble.isCastableToDefinedType("name"));
        Option optionFloat = new Option("name").type(OptionType.BOOLEAN);
        Assert.assertFalse((boolean)optionFloat.isCastableToDefinedType("15"));
    }
}

